package net.luohuasheng.bee.proxy.rest.convent;

import net.luohuasheng.bee.proxy.rest.dto.DownloadData;
import org.springframework.http.HttpHeaders;
import org.springframework.util.StreamUtils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * @author wusm
 */
public class DownloadProcessor {
    private static final ThreadLocal<DownloadData> DATA_THREAD_LOCAL = new ThreadLocal<>();

    public static void create() {
        DATA_THREAD_LOCAL.set(new DownloadData());
    }

    public static boolean load(InputStream inputStream, HttpHeaders header) {
        DownloadData downloadData = DATA_THREAD_LOCAL.get();
        if (downloadData != null) {
            downloadData.setHeader(header);
            try {
                downloadData.setInputStream(new ByteArrayInputStream(StreamUtils.copyToByteArray(inputStream)));
            } catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        } else {
            return false;
        }
    }

    public static DownloadData get() {
        try {
            return DATA_THREAD_LOCAL.get();
        } finally {
            DATA_THREAD_LOCAL.remove();
        }
    }

}
