/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.jdbc.generate.utils.id;

import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.regex.Pattern;
import net.luohuasheng.bee.jdbc.generate.utils.id.IdGenerator;
import net.luohuasheng.bee.jdbc.generate.utils.id.SnWorker;
import net.luohuasheng.bee.jdbc.generate.utils.id.SnowflakeIdGenerator;

public class IdUtil {
    private static IdGenerator idGenerator;
    private static SnWorker snWorker;

    public static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }

    public static synchronized long getId() {
        return idGenerator.nextId();
    }

    public static synchronized String getSn() {
        Long thisTime = Long.parseLong(new SimpleDateFormat("yyyyMMdd").format(new Date()));
        BigInteger bigInteger = new BigInteger(thisTime.toString());
        bigInteger = bigInteger.multiply(BigInteger.valueOf((long)Math.pow(10.0, 12.0))).add(BigInteger.valueOf(snWorker.nextId() % 1000000000000L));
        return bigInteger.toString();
    }

    public static void main(String[] args) {
        for (int i = 0; i < 100; ++i) {
            System.out.println(IdUtil.getId());
        }
    }

    static {
        snWorker = new SnWorker(1L, 1L);
        Properties props = System.getProperties();
        String workerId = props.getProperty("WORKER_ID");
        idGenerator = workerId != null && IdUtil.isNumeric(workerId) ? new SnowflakeIdGenerator(Long.parseLong(workerId)) : new SnowflakeIdGenerator(1L);
    }
}

