/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.jdbc.generate.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsFactory;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.luohuasheng.bee.jdbc.generate.model.GeneratorDto;
import net.luohuasheng.bee.proxy.core.exception.JsonException;

public class GeneratorUtils {
    private static final String[] PROPERTIES_FILE_NAMES = new String[]{"config/generator.yml", "config/generator.xml", "config/generator.properties"};

    public static GeneratorDto load() {
        ObjectMapper mapper = null;
        String result = null;
        for (int i = 0; i < PROPERTIES_FILE_NAMES.length; ++i) {
            String fileName = PROPERTIES_FILE_NAMES[i];
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
            if (in == null) continue;
            result = ((Stream)new BufferedReader(new InputStreamReader(in)).lines().parallel()).collect(Collectors.joining(System.lineSeparator()));
            if (i == 2) {
                mapper = new ObjectMapper((JsonFactory)JavaPropsFactory.builder().build());
                result = result.replaceAll("lhs.generator.", "");
                break;
            }
            if (i == 0) {
                result = result.replace("lhs:\n", "").trim().replace("generator:\n", "");
                mapper = new ObjectMapper((JsonFactory)YAMLFactory.builder().build());
                break;
            }
            result = result.replace("<lhs>\n", "").replace("</lhs>\n", "").replace("</generator>\n", "").replace("<generator>\n", "");
            mapper = new ObjectMapper((JsonFactory)XmlFactory.builder().build());
            break;
        }
        try {
            ((ObjectMapper)Objects.requireNonNull(mapper)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            mapper.setPropertyNamingStrategy(PropertyNamingStrategies.KEBAB_CASE);
            return (GeneratorDto)mapper.readValue(result, GeneratorDto.class);
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }
}

