/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.jdbc.generate.utils.typemapping;

import net.luohuasheng.bee.proxy.core.enums.DataType;

public class DatabaseDataTypesUtils {
    public static boolean isFloatNumber(String javaType) {
        if (javaType.endsWith("Float") || javaType.endsWith("Double") || javaType.endsWith("BigDecimal") || javaType.endsWith("BigInteger")) {
            return true;
        }
        return javaType.endsWith("float") || javaType.endsWith("double") || javaType.endsWith("BigDecimal") || javaType.endsWith("BigInteger");
    }

    public static boolean isIntegerNumber(String javaType) {
        if (javaType.endsWith("Long") || javaType.endsWith("Integer") || javaType.endsWith("Short") || javaType.endsWith("Byte") || javaType.endsWith("Boolean")) {
            return true;
        }
        return javaType.endsWith("long") || javaType.endsWith("int") || javaType.endsWith("short") || javaType.endsWith("byte") || javaType.endsWith("boolean");
    }

    public static boolean isDate(String javaType) {
        return javaType.endsWith("Date");
    }

    public static boolean isString(String javaType) {
        return javaType.endsWith("String");
    }

    public static String getPreferredJavaType(int sqlType, int size, int decimalDigits) {
        if (sqlType == DataType.INTEGER.getDataCategory()) {
            if (size == 1) {
                return "java.lang.Boolean";
            }
            if (size < 3) {
                return "java.lang.Byte";
            }
            if (size < 5) {
                return "java.lang.Short";
            }
            if (size < 10) {
                return "java.lang.Integer";
            }
            return "java.lang.Long";
        }
        if (sqlType == DataType.DECIMAL.getDataCategory()) {
            return "java.lang.Double";
        }
        if (sqlType == DataType.DATE.getDataCategory() || sqlType == DataType.DATE_TIME.getDataCategory()) {
            return "java.util.Date";
        }
        return "java.lang.String";
    }
}

