/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.jdbc.generate.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static final Map<String, String> XML = new HashMap<String, String>();
    private static final Random RANDOM;
    static Pattern three;
    static Pattern two;

    public static String removeCrlf(String str) {
        if (str == null) {
            return null;
        }
        return StringUtils.join(StringUtils.tokenizeToStringArray(str, "\t\n\r\f"), " ");
    }

    public static String unescapeXml(String str) {
        if (str == null) {
            return null;
        }
        for (String key : XML.keySet()) {
            String value = XML.get(key);
            str = StringUtils.replace(str, "&" + key + ";", value);
        }
        return str;
    }

    public static String escapeXml(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            String escapedStr = StringUtils.getEscapedStringByChar(c);
            if (escapedStr == null) {
                sb.append(c);
                continue;
            }
            sb.append(escapedStr);
        }
        return sb.toString();
    }

    public static String escapeXml(String str, String escapeChars) {
        if (str == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (escapeChars.indexOf(c) < 0) {
                sb.append(c);
                continue;
            }
            String escapedStr = StringUtils.getEscapedStringByChar(c);
            if (escapedStr == null) {
                sb.append(c);
                continue;
            }
            sb.append(escapedStr);
        }
        return sb.toString();
    }

    private static String getEscapedStringByChar(char c) {
        String escapedStr = null;
        for (String key : XML.keySet()) {
            String value = XML.get(key);
            if (c != value.charAt(0)) continue;
            escapedStr = "&" + key + ";";
        }
        return escapedStr;
    }

    public static String removePrefix(String str, String prefix) {
        return StringUtils.removePrefix(str, prefix, false);
    }

    public static String removePrefix(String str, String prefix, boolean ignoreCase) {
        if (str == null) {
            return null;
        }
        if (prefix == null) {
            return str;
        }
        if (ignoreCase ? str.toLowerCase().startsWith(prefix.toLowerCase()) : str.startsWith(prefix)) {
            return str.substring(prefix.length());
        }
        return str;
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static String getExtension(String str) {
        if (str == null) {
            return null;
        }
        int i = str.lastIndexOf(46);
        if (i >= 0) {
            return str.substring(i + 1);
        }
        return null;
    }

    public static String insertBefore(String content, String compareToken, String insertString) {
        if (content.indexOf(insertString) >= 0) {
            return content;
        }
        int index = content.indexOf(compareToken);
        if (index >= 0) {
            return new StringBuffer(content).insert(index, insertString).toString();
        }
        throw new IllegalArgumentException("not found insert location by compareToken:" + compareToken + " content:" + content);
    }

    public static String insertAfter(String content, String compareToken, String insertString) {
        if (content.indexOf(insertString) >= 0) {
            return content;
        }
        int index = content.indexOf(compareToken);
        if (index >= 0) {
            return new StringBuffer(content).insert(index + compareToken.length(), insertString).toString();
        }
        throw new IllegalArgumentException("not found insert location by compareToken:" + compareToken + " content:" + content);
    }

    public static int countOccurrencesOf(String str, String sub) {
        int idx;
        if (str == null || sub == null || str.length() == 0 || sub.length() == 0) {
            return 0;
        }
        int count = 0;
        int pos = 0;
        while ((idx = str.indexOf(sub, pos)) != -1) {
            ++count;
            pos = idx + sub.length();
        }
        return count;
    }

    public static boolean contains(String str, String ... keywords) {
        if (str == null) {
            return false;
        }
        if (keywords == null) {
            throw new IllegalArgumentException("'keywords' must be not null");
        }
        for (String keyword : keywords) {
            if (!str.contains(keyword.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static String defaultString(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public static String defaultIfEmpty(Object value, String defaultValue) {
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        return value.toString();
    }

    public static String makeAllWordFirstLetterUpperCase(String sqlName) {
        String[] strs = sqlName.toLowerCase().split("_");
        String result = "";
        String preStr = "";
        for (int i = 0; i < strs.length; ++i) {
            result = preStr.length() == 1 ? result + strs[i] : result + StringUtils.capitalize(strs[i]);
            preStr = strs[i];
        }
        return result;
    }

    public static int indexOfByRegex(String input, String regex) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(input);
        if (m.find()) {
            return m.start();
        }
        return -1;
    }

    public static String toJavaVariableName(String str) {
        return StringUtils.uncapitalize(StringUtils.toJavaClassName(str));
    }

    public static String toJavaClassName(String str) {
        return StringUtils.makeAllWordFirstLetterUpperCase(StringUtils.toUnderscoreName(str));
    }

    public static String getJavaClassSimpleName(String clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.lastIndexOf(".") >= 0) {
            return clazz.substring(clazz.lastIndexOf(".") + 1);
        }
        return clazz;
    }

    public static String removeMany(String inString, String ... keywords) {
        if (inString == null) {
            return null;
        }
        for (String k : keywords) {
            inString = StringUtils.replace(inString, k, "");
        }
        return inString;
    }

    public static void appendReplacement(Matcher m, StringBuffer sb, String replacement) {
        replacement = StringUtils.replace(replacement, "$", "\\$");
        m.appendReplacement(sb, replacement);
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (inString == null) {
            return null;
        }
        if (oldPattern == null || newPattern == null) {
            return inString;
        }
        StringBuffer sbuf = new StringBuffer();
        int pos = 0;
        int index = inString.indexOf(oldPattern);
        int patLen = oldPattern.length();
        while (index >= 0) {
            sbuf.append(inString.substring(pos, index));
            sbuf.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sbuf.append(inString.substring(pos));
        return sbuf.toString();
    }

    public static String capitalize(String str) {
        return StringUtils.changeFirstCharacterCase(str, true);
    }

    public static String uncapitalize(String str) {
        return StringUtils.changeFirstCharacterCase(str, false);
    }

    private static String changeFirstCharacterCase(String str, boolean capitalize) {
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str.length());
        if (capitalize) {
            buf.append(Character.toUpperCase(str.charAt(0)));
        } else {
            buf.append(Character.toLowerCase(str.charAt(0)));
        }
        buf.append(str.substring(1));
        return buf.toString();
    }

    public static String randomNumeric(int count) {
        return StringUtils.random(count, false, true);
    }

    public static String random(int count, boolean letters, boolean numbers) {
        return StringUtils.random(count, 0, 0, letters, numbers);
    }

    public static String random(int count, int start, int end, boolean letters, boolean numbers) {
        return StringUtils.random(count, start, end, letters, numbers, null, RANDOM);
    }

    public static String random(int count, int start, int end, boolean letters, boolean numbers, char[] chars, Random random) {
        if (count == 0) {
            return "";
        }
        if (count < 0) {
            throw new IllegalArgumentException("Requested random string length " + count + " is less than 0.");
        }
        if (start == 0 && end == 0) {
            end = 123;
            start = 32;
            if (!letters && !numbers) {
                start = 0;
                end = Integer.MAX_VALUE;
            }
        }
        char[] buffer = new char[count];
        int gap = end - start;
        while (count-- != 0) {
            char ch = chars == null ? (char)(random.nextInt(gap) + start) : chars[random.nextInt(gap) + start];
            if (letters && Character.isLetter(ch) || numbers && Character.isDigit(ch) || !letters && !numbers) {
                if (ch >= '\udc00' && ch <= '\udfff') {
                    if (count == 0) {
                        ++count;
                        continue;
                    }
                    buffer[count] = ch;
                    buffer[--count] = (char)(55296 + random.nextInt(128));
                    continue;
                }
                if (ch >= '\ud800' && ch <= '\udb7f') {
                    if (count == 0) {
                        ++count;
                        continue;
                    }
                    buffer[count] = (char)(56320 + random.nextInt(128));
                    buffer[--count] = ch;
                    continue;
                }
                if (ch >= '\udb80' && ch <= '\udbff') {
                    ++count;
                    continue;
                }
                buffer[count] = ch;
                continue;
            }
            ++count;
        }
        return new String(buffer);
    }

    public static String toUnderscoreName(String name) {
        if (name == null) {
            return null;
        }
        String filteredName = name;
        if (filteredName.indexOf("_") >= 0 && filteredName.equals(filteredName.toUpperCase())) {
            filteredName = filteredName.toLowerCase();
        }
        if (filteredName.indexOf("_") == -1 && filteredName.equals(filteredName.toUpperCase())) {
            filteredName = filteredName.toLowerCase();
        }
        StringBuffer result = new StringBuffer();
        if (filteredName != null && filteredName.length() > 0) {
            result.append(filteredName.substring(0, 1).toLowerCase());
            for (int i = 1; i < filteredName.length(); ++i) {
                String preChart = filteredName.substring(i - 1, i);
                String c = filteredName.substring(i, i + 1);
                if (c.equals("_")) {
                    result.append("_");
                    continue;
                }
                if (preChart.equals("_")) {
                    result.append(c.toLowerCase());
                    continue;
                }
                if (c.matches("\\d")) {
                    result.append(c);
                    continue;
                }
                if (c.equals(c.toUpperCase())) {
                    result.append("_");
                    result.append(c.toLowerCase());
                    continue;
                }
                result.append(c);
            }
        }
        return result.toString();
    }

    public static String removeEndWiths(String inputString, String ... endWiths) {
        for (String endWith : endWiths) {
            if (!inputString.endsWith(endWith)) continue;
            return inputString.substring(0, inputString.length() - endWith.length());
        }
        return inputString;
    }

    public static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        for (int j = 0; j < substring.length(); ++j) {
            int i = index + j;
            if (i < str.length() && str.charAt(i) == substring.charAt(j)) continue;
            return false;
        }
        return true;
    }

    public static String captureName(String str) {
        char[] cs = str.toCharArray();
        cs[0] = (char)(cs[0] - 32);
        return String.valueOf(cs);
    }

    public static String[] tokenizeToStringArray(String str, String seperators) {
        if (str == null) {
            return new String[0];
        }
        StringTokenizer tokenlizer = new StringTokenizer(str, seperators);
        ArrayList<Object> result = new ArrayList<Object>();
        while (tokenlizer.hasMoreElements()) {
            Object s = tokenlizer.nextElement();
            result.add(s);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String join(List list, String seperator) {
        return StringUtils.join(list.toArray(new Object[0]), seperator);
    }

    public static String replace(int start, int end, String str, String replacement) {
        String before = str.substring(0, start);
        String after = str.substring(end);
        return before + replacement + after;
    }

    public static String join(Object[] array, String seperator) {
        if (array == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            result.append(array[i]);
            if (i == array.length - 1) continue;
            result.append(seperator);
        }
        return result.toString();
    }

    public static int containsCount(String string, String keyword) {
        int indexOf;
        if (string == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < string.length() && (indexOf = string.indexOf(keyword, i)) >= 0; ++i) {
            ++count;
            i = indexOf;
        }
        return count;
    }

    public static String getByRegex(String str, String regex) {
        return StringUtils.getByRegex(str, regex, 0);
    }

    public static String getByRegex(String str, String regex, int group) {
        if (regex == null) {
            throw new NullPointerException();
        }
        if (group < 0) {
            throw new IllegalArgumentException();
        }
        if (str == null) {
            return null;
        }
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(str);
        if (m.find()) {
            return m.group(group);
        }
        return null;
    }

    public static String removeIbatisOrderBy(String sql) {
        String orderByRemovedSql = sql.replaceAll("(?si)<\\w+[^>]*?>\\s*order\\s+by\\s+[^<]+?</\\w+>", "").replaceAll("(?i)<\\w+[\\w\\s='\"]+prepend[\\w\\s='\"]*?order\\s+by\\s*['\"][^>]*?>[^<]+</\\w+>", "").replaceAll("(?i)\\s*order\\s+by\\s+.*", "");
        return StringUtils.removeXmlTagIfBodyEmpty(StringUtils.removeXmlTagIfBodyEmpty(StringUtils.removeXmlTagIfBodyEmpty(StringUtils.removeXmlTagIfBodyEmpty(orderByRemovedSql))));
    }

    public static String removeXmlTagIfBodyEmpty(String sql) {
        return sql.replaceAll("<\\w+[^>]*?>\\s+</\\w+>", "");
    }

    static {
        XML.put("apos", "'");
        XML.put("quot", "\"");
        XML.put("amp", "&");
        XML.put("lt", "<");
        XML.put("gt", ">");
        RANDOM = new Random();
        three = Pattern.compile("(.*)\\((.*),(.*)\\)");
        two = Pattern.compile("(.*)\\((.*)\\)");
    }
}

