/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.jdbc.generate.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import net.luohuasheng.bee.jdbc.generate.model.ColumnVo;
import net.luohuasheng.bee.jdbc.generate.utils.GeneratorUtils;
import net.luohuasheng.bee.jdbc.generate.utils.StringUtils;

public class TableVo
implements Serializable,
Cloneable {
    private String sqlName;
    private String remarks;
    private String className;
    private String tableAlias;
    private String tableType;
    private LinkedHashSet<ColumnVo> columnVos = new LinkedHashSet();

    public LinkedHashSet<ColumnVo> getColumns() {
        return this.columnVos;
    }

    public void addColumn(ColumnVo columnVo) {
        this.columnVos.add(columnVo);
    }

    public String getSqlName() {
        return this.sqlName;
    }

    public void setSqlName(String sqlName) {
        this.sqlName = sqlName;
    }

    public static String removeTableSqlNamePrefix(String sqlName) {
        String prefixs = GeneratorUtils.load().getRemovePrefixs();
        for (String prefix : prefixs.split(",")) {
            String removedPrefixSqlName = StringUtils.removePrefix(sqlName, prefix, true);
            if (removedPrefixSqlName.equals(sqlName)) continue;
            return removedPrefixSqlName;
        }
        return sqlName;
    }

    public String getRemarks() {
        if (StringUtils.isBlank(this.remarks)) {
            return this.getClassNameFirstLower();
        }
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public void setClassName(String customClassName) {
        this.className = customClassName;
    }

    public String getClassName() {
        if (StringUtils.isBlank(this.className)) {
            String removedPrefixSqlName = TableVo.removeTableSqlNamePrefix(this.sqlName);
            return StringUtils.makeAllWordFirstLetterUpperCase(StringUtils.toUnderscoreName(removedPrefixSqlName));
        }
        return this.className;
    }

    public String getTableAlias() {
        if (StringUtils.isNotBlank(this.tableAlias)) {
            return this.tableAlias;
        }
        return StringUtils.removeCrlf(StringUtils.defaultIfEmpty(this.getRemarks(), this.getClassName()));
    }

    public void setTableAlias(String v) {
        this.tableAlias = v;
    }

    public String getClassNameLowerCase() {
        return this.getClassName().toLowerCase();
    }

    public String getUnderscoreName() {
        return StringUtils.toUnderscoreName(this.getClassName()).toLowerCase();
    }

    public String getClassNameFirstLower() {
        return StringUtils.uncapitalize(this.getClassName());
    }

    public String getConstantName() {
        return StringUtils.toUnderscoreName(this.getClassName()).toUpperCase();
    }

    public int getPkCount() {
        int pkCount = 0;
        for (ColumnVo c : this.columnVos) {
            if (!c.isPk()) continue;
            ++pkCount;
        }
        return pkCount;
    }

    public List<ColumnVo> getCompositeIdColumns() {
        return this.getPkColumns();
    }

    public List<ColumnVo> getPkColumns() {
        ArrayList<ColumnVo> results = new ArrayList<ColumnVo>();
        for (ColumnVo c : this.getColumns()) {
            if (!c.isPk()) continue;
            results.add(c);
        }
        return results;
    }

    public List<ColumnVo> getNotPkColumns() {
        ArrayList<ColumnVo> results = new ArrayList<ColumnVo>();
        for (ColumnVo c : this.getColumns()) {
            if (c.isPk()) continue;
            results.add(c);
        }
        return results;
    }

    public ColumnVo getPkColumn() {
        if (this.getPkColumns().isEmpty()) {
            return null;
        }
        return this.getPkColumns().get(0);
    }

    public ColumnVo getColumnByName(String name) {
        ColumnVo c = this.getColumnBySqlName(name);
        if (c == null) {
            c = this.getColumnBySqlName(StringUtils.toUnderscoreName(name));
        }
        return c;
    }

    public ColumnVo getColumnBySqlName(String sqlName) {
        for (ColumnVo c : this.getColumns()) {
            if (!c.getSqlName().equalsIgnoreCase(sqlName)) continue;
            return c;
        }
        return null;
    }

    public ColumnVo getRequiredColumnBySqlName(String sqlName) {
        if (this.getColumnBySqlName(sqlName) == null) {
            throw new IllegalArgumentException("not found column with sqlName:" + sqlName + " on table:" + this.getSqlName());
        }
        return this.getColumnBySqlName(sqlName);
    }

    public String getTableType() {
        return this.tableType;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }
}

