package net.luohuasheng.bee.jdbc.generate.model;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author wusuoming
 */
public class GeneratorDto {
    private String name;
    private String description;
    private boolean overwrite;
    private boolean append;

    private String basePackage;
    private String xmlPackage;
    private String removePrefixs;
    private DataSourceDto datasource;
    private TemplateDto template;
    private List<CenterDto> centers;
    private Map<String, String> extend;
    private Set<String> modules;

    public GeneratorDto() {
    }

    public DataSourceDto getDatasource() {
        return datasource;
    }

    public void setDatasource(DataSourceDto datasource) {
        this.datasource = datasource;
    }


    public Map<String, String> getExtend() {
        return replace(extend);
    }

    protected static Map<String, String> replace(Map<String, String> data) {
        if (data != null) {
            Set<String> keys = new HashSet<>(data.keySet());
            Map<String, String> finalData = data;
            keys.forEach(key -> {
                String value = finalData.get(key);
                finalData.remove(key);
                String[] keySplit = key.split("-");
                if (keySplit.length > 1) {
                    for (int i = 1; i < keySplit.length; i++) {
                        String v = keySplit[i];
                        char[] cs = v.toCharArray();
                        cs[0] -= 32;
                        keySplit[i] = String.valueOf(cs);
                    }
                    key = String.join("", keySplit);
                }
                finalData.put(key, value);
            });
        } else {
            data = new HashMap<>();
        }
        return data;
    }


    public void setExtend(Map<String, String> extend) {
        this.extend = extend;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }


    public TemplateDto getTemplate() {
        return template;
    }

    public void setTemplate(TemplateDto template) {
        this.template = template;
    }

    public String getbasePackage() {
        return basePackage;
    }

    public void setbasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public String getXmlPackage() {
        return xmlPackage == null ? "" : xmlPackage;
    }

    public void setXmlPackage(String xmlPackage) {
        this.xmlPackage = xmlPackage;
    }

    public List<CenterDto> getCenters() {
        return centers;
    }

    public void setCenters(List<CenterDto> centers) {
        this.centers = centers;
    }


    public Set<String> getModules() {
        return modules;
    }

    public void setModules(String modules) {
        this.modules = Arrays.stream(modules.toLowerCase().split(",")).collect(Collectors.toSet());
    }

    public String getRemovePrefixs() {
        return removePrefixs == null ? "" : removePrefixs;
    }

    public void setRemovePrefix(String removePrefixs) {
        this.removePrefixs = removePrefixs;
    }

    public boolean isOverwrite() {
        return overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isAppend() {
        return append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }
}
