/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.jdbc.generate.model;

import java.io.Serializable;
import net.luohuasheng.bee.jdbc.generate.model.TableVo;
import net.luohuasheng.bee.jdbc.generate.utils.StringUtils;
import net.luohuasheng.bee.jdbc.generate.utils.typemapping.DatabaseDataTypesUtils;
import net.luohuasheng.bee.jdbc.generate.utils.typemapping.JavaPrimitiveTypeMapping;
import net.luohuasheng.bee.jdbc.tools.common.enums.ColumnType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ColumnVo
implements Serializable,
Cloneable {
    private final TableVo tableVo;
    private final ColumnType sqlType;
    private final String sqlName;
    private boolean isPk;
    private final int size;
    private final int decimalDigits;
    private boolean isNullable;
    private final String remarks;
    private String javaType;
    private String columnAlias;
    private String columnName;

    public ColumnVo(TableVo tableVo, ColumnType sqlType, String sqlName, int size, int decimalDigits, boolean isPk, boolean isNullable, String remarks) {
        this.tableVo = tableVo;
        this.sqlType = sqlType;
        this.sqlName = sqlName;
        this.size = size;
        this.decimalDigits = decimalDigits;
        this.isPk = isPk;
        this.isNullable = isNullable;
        this.remarks = remarks;
        this.initOtherProperties();
    }

    public ColumnType getSqlType() {
        return this.sqlType;
    }

    public TableVo getTable() {
        return this.tableVo;
    }

    public int getSize() {
        return this.size;
    }

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public String getSqlName() {
        return this.sqlName;
    }

    public boolean isPk() {
        return this.isPk;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public String getRemarks() {
        if (StringUtils.isBlank(this.remarks)) {
            return this.getColumnNameFirstLower();
        }
        return this.remarks;
    }

    public void setNullable(boolean v) {
        this.isNullable = v;
    }

    public void setPk(boolean v) {
        this.isPk = v;
    }

    public String getUnderscoreName() {
        return this.getSqlName().toLowerCase();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getColumnNameFirstLower() {
        return StringUtils.uncapitalize(this.getColumnName());
    }

    public String getColumnNameLowerCase() {
        return this.getColumnName().toLowerCase();
    }

    public String getColumnNameLower() {
        return this.getColumnNameFirstLower();
    }

    public String getColumnAlias() {
        return this.columnAlias;
    }

    public String getConstantName() {
        return StringUtils.toUnderscoreName(this.getColumnName()).toUpperCase();
    }

    public boolean getIsStringColumn() {
        return DatabaseDataTypesUtils.isString(this.getJavaType());
    }

    public boolean getIsDateTimeColumn() {
        return DatabaseDataTypesUtils.isDate(this.getJavaType());
    }

    public boolean getIsNumberColumn() {
        return DatabaseDataTypesUtils.isFloatNumber(this.getJavaType()) || DatabaseDataTypesUtils.isIntegerNumber(this.getJavaType());
    }

    public String getJavaType() {
        return this.javaType;
    }

    public String getSimpleJavaType() {
        return StringUtils.getJavaClassSimpleName(this.getJavaType());
    }

    public String getPossibleShortJavaType() {
        if (this.getJavaType().startsWith("java.lang.")) {
            return this.getSimpleJavaType();
        }
        return this.getJavaType();
    }

    public boolean isPrimitive() {
        return JavaPrimitiveTypeMapping.getWrapperTypeOrNull(this.getJavaType()) != null;
    }

    public String getPrimitiveJavaType() {
        return JavaPrimitiveTypeMapping.getPrimitiveType(this.getSimpleJavaType());
    }

    public void setJavaType(String javaType) {
        this.javaType = javaType;
    }

    public void setColumnAlias(String columnAlias) {
        this.columnAlias = columnAlias;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    private void initOtherProperties() {
        this.javaType = this.sqlType.getJavaType().getTypeName().replace("java.lang.", "");
        this.columnName = StringUtils.makeAllWordFirstLetterUpperCase(StringUtils.toUnderscoreName(this.getSqlName()));
        this.columnAlias = StringUtils.removeCrlf(StringUtils.defaultIfEmpty(this.getRemarks(), this.getColumnNameFirstLower()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnVo columnVo = (ColumnVo)o;
        return new EqualsBuilder().append((Object)this.sqlType, (Object)columnVo.sqlType).append(this.isPk, columnVo.isPk).append(this.size, columnVo.size).append(this.decimalDigits, columnVo.decimalDigits).append(this.isNullable, columnVo.isNullable).append((Object)this.tableVo, (Object)columnVo.tableVo).append((Object)this.sqlName, (Object)columnVo.sqlName).append((Object)this.remarks, (Object)columnVo.remarks).append((Object)this.javaType, (Object)columnVo.javaType).append((Object)this.columnAlias, (Object)columnVo.columnAlias).append((Object)this.columnName, (Object)columnVo.columnName).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.tableVo).append((Object)this.sqlType).append((Object)this.sqlName).append(this.isPk).append(this.size).append(this.decimalDigits).append(this.isNullable).append((Object)this.remarks).append((Object)this.javaType).append((Object)this.columnAlias).append((Object)this.columnName).toHashCode();
    }
}

