/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.jdbc.generate.helper;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import net.luohuasheng.bee.jdbc.generate.directive.MapperElDirective;
import net.luohuasheng.bee.jdbc.generate.model.CenterDto;
import net.luohuasheng.bee.jdbc.generate.model.ColumnVo;
import net.luohuasheng.bee.jdbc.generate.model.GeneratorDto;
import net.luohuasheng.bee.jdbc.generate.model.TableVo;
import net.luohuasheng.bee.jdbc.generate.utils.FileUtils;
import net.luohuasheng.bee.jdbc.generate.utils.GeneratorUtils;
import net.luohuasheng.bee.jdbc.generate.utils.StringUtils;
import net.luohuasheng.bee.jdbc.generate.utils.id.IdUtil;
import net.luohuasheng.bee.jdbc.tools.common.utils.CollectionUtils;
import net.luohuasheng.bee.jdbc.tools.common.utils.DataSourceUtils;
import net.luohuasheng.bee.jdbc.tools.common.utils.StructureUtils;
import net.luohuasheng.bee.jdbc.tools.component.structure.dto.ColumnDto;
import net.luohuasheng.bee.jdbc.tools.component.structure.dto.TableDto;

public class TemplateHelper {
    private final GeneratorDto generatorDto;
    private final Set<String> tableNames = new HashSet<String>();
    private final JavaParser javaParser = new JavaParser();

    private TemplateHelper(GeneratorDto generatorDto) {
        this.generatorDto = generatorDto;
    }

    public static TemplateHelper build() {
        return new TemplateHelper(GeneratorUtils.load());
    }

    public static TemplateHelper build(GeneratorDto generatorDto) {
        return new TemplateHelper(generatorDto);
    }

    public void generateByAllTable(String ... tableNames) {
        this.tableNames.addAll(Arrays.asList(tableNames));
        this.loadDbTable();
    }

    public void loadDbTable() {
        if (CollectionUtils.isEmpty(this.generatorDto.getCenters())) {
            this.loadDbTable(DataSourceUtils.createDataSource((String)this.generatorDto.getDatasource().getUrl(), (String)this.generatorDto.getDatasource().getUsername(), (String)this.generatorDto.getDatasource().getPassword()), null);
        } else {
            for (CenterDto center : this.generatorDto.getCenters()) {
                this.tableNames.clear();
                if (center.getDatasource() == null) continue;
                this.loadDbTable(DataSourceUtils.createDataSource((String)center.getDatasource().getUrl(), (String)center.getDatasource().getUsername(), (String)center.getDatasource().getPassword()), center);
            }
            if (this.generatorDto.getCenters().stream().filter(centerDto -> centerDto.getDatasource() == null).findAny().orElse(null) == null) {
                this.loadDbTable(DataSourceUtils.createDataSource((String)this.generatorDto.getDatasource().getUrl(), (String)this.generatorDto.getDatasource().getUsername(), (String)this.generatorDto.getDatasource().getPassword()), null);
            }
        }
    }

    public void loadDbTable(DataSource dataSource, CenterDto center) {
        List list = StructureUtils.loadTables((DataSource)dataSource, (String)"table", (boolean)true);
        for (TableDto tableDto : list) {
            if (!this.tableNames.isEmpty() && !this.tableNames.contains(tableDto.getTableName())) continue;
            tableDto.setRemarks(StringUtils.isBlank(tableDto.getRemarks()) ? "" : tableDto.getRemarks().replaceAll("\n", " "));
            if (center == null && !CollectionUtils.isEmpty(this.generatorDto.getCenters())) {
                return;
            }
            System.out.println("load   table name " + tableDto.getTableName());
            System.out.println("load   table remark " + tableDto.getRemarks());
            TableVo tableVo = new TableVo();
            tableVo.setRemarks(tableDto.getRemarks());
            tableVo.setSqlName(tableDto.getTableName());
            tableVo.setTableAlias(tableVo.getClassNameFirstLower());
            List<ColumnDto> columnDtos = this.loadDbColumn(dataSource, tableDto.getTableName());
            for (ColumnDto columnDto : columnDtos) {
                columnDto.setRemarks(StringUtils.isBlank(columnDto.getRemarks()) ? "" : columnDto.getRemarks().replaceAll("\n", " "));
                ColumnVo columnVo = new ColumnVo(tableVo, columnDto.getDataType(), columnDto.getColumnName(), columnDto.getColumnSize(), columnDto.getDecimalDigits(), columnDto.isPk(), columnDto.isNullable(), columnDto.getRemarks());
                tableVo.addColumn(columnVo);
            }
            try {
                this.readTemplate(center, tableVo);
            }
            catch (TemplateException | IOException e) {
                e.printStackTrace();
            }
        }
    }

    public List<ColumnDto> loadDbColumn(DataSource dataSource, String tableName) {
        return StructureUtils.loadTableColumn((DataSource)dataSource, (String)tableName);
    }

    private Map<String, Object> loadTemplateData(CenterDto center, TableVo tableVo) {
        HashMap<String, Object> map = new HashMap<String, Object>(this.generatorDto.getExtend());
        this.loadBaseData(map, tableVo);
        String tableName = tableVo.getSqlName();
        if (!StringUtils.isBlank(this.generatorDto.getRemovePrefixs())) {
            tableName = TableVo.removeTableSqlNamePrefix(tableName);
        }
        String prefix = tableName.split("_")[0];
        if (center == null) {
            center = this.generatorDto.getCenters().stream().filter(centerDto -> centerDto.getModules().contains(prefix)).findAny().orElse(null);
        }
        this.loadModuleData(map, prefix, center);
        return map;
    }

    private void loadBaseData(Map<String, Object> map, TableVo tableVo) {
        map.put("now", new Date());
        map.put("name", this.generatorDto.getName());
        map.put("description", this.generatorDto.getDescription());
        map.put("mapperEl", new MapperElDirective());
        map.put("table", tableVo);
        map.put("uid", IdUtil.getId() + "");
        map.put("className", tableVo.getClassName());
        map.put("basePackage", this.generatorDto.getbasePackage());
        map.put("basePackageDir", this.generatorDto.getbasePackage().replace('.', '/'));
        map.put("xmlPackageDir", this.generatorDto.getXmlPackage().replace('.', '/'));
    }

    private void loadModuleData(Map<String, Object> map, String prefix, CenterDto center) {
        if (center == null) {
            map.put("centerName", this.generatorDto.getName());
            map.put("centerNameCap", StringUtils.captureName(this.generatorDto.getName()));
            map.put("centerCode", "00");
            map.put("centerPort", 8080);
            map.put("modules", this.generatorDto.getModules());
            map.put("url", this.generatorDto.getDatasource().getUrl());
            map.put("password", this.generatorDto.getDatasource().getPassword());
            map.put("username", this.generatorDto.getDatasource().getUsername());
        } else {
            map.putAll(center.getExtend());
            map.put("centerName", center.getName());
            map.put("centerNameCap", StringUtils.captureName(center.getName()));
            map.put("description", center.getDescription());
            map.put("centerCode", center.getCode());
            map.put("centerPort", center.getPort().toString());
            map.put("modules", center.getModules());
            if (center.getDatasource() != null) {
                map.put("url", center.getDatasource().getUrl());
                map.put("password", center.getDatasource().getPassword());
                map.put("username", center.getDatasource().getUsername());
            } else {
                map.put("url", this.generatorDto.getDatasource().getUrl());
                map.put("password", this.generatorDto.getDatasource().getPassword());
                map.put("username", this.generatorDto.getDatasource().getUsername());
            }
        }
        map.put("moduleName", prefix);
    }

    public void readTemplate(CenterDto center, TableVo tableVo) throws IOException, TemplateException {
        System.out.println("****************Relative****************");
        String dir = this.generatorDto.getTemplate().getDir();
        String target = this.generatorDto.getTemplate().getTarget();
        if (StringUtils.isBlank(target)) {
            target = ".";
        }
        for (String s : FileUtils.readDir(dir, null)) {
            String filePath = dir + s;
            String fullName = FileUtils.printFileName(filePath, this.loadTemplateData(center, tableVo)).replaceAll(dir, "").replaceAll("//", "/");
            File file = new File(target + fullName);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            } else if (file.exists() && !this.generatorDto.isOverwrite()) continue;
            if (file.exists() && this.generatorDto.isAppend()) {
                String name;
                if (!fullName.endsWith(".java")) continue;
                File fileTemp = File.createTempFile("temp", ".java");
                this.printFile(center, tableVo, filePath, fileTemp);
                ParseResult result = this.javaParser.parse(file);
                CompilationUnit value = result.getResult().orElse(null);
                ParseResult result2 = this.javaParser.parse(fileTemp);
                CompilationUnit value2 = result2.getResult().orElse(null);
                HashSet<String> imports = new HashSet<String>();
                HashSet<String> annotations = new HashSet<String>();
                for (ImportDeclaration importDeclaration : Objects.requireNonNull(value).getImports()) {
                    imports.add(importDeclaration.getNameAsString());
                }
                for (ImportDeclaration importDeclaration : Objects.requireNonNull(value2).getImports()) {
                    String name2 = importDeclaration.getNameAsString();
                    if (imports.contains(name2)) continue;
                    value.getImports().add((Node)importDeclaration);
                }
                TypeDeclaration type = value.getType(0);
                TypeDeclaration type2 = value2.getType(0);
                for (AnnotationExpr annotationExpr : Objects.requireNonNull(type).getAnnotations()) {
                    annotations.add(annotationExpr.getNameAsString());
                }
                for (AnnotationExpr annotationExpr : Objects.requireNonNull(type2).getAnnotations()) {
                    name = annotationExpr.getNameAsString();
                    if (annotations.contains(name)) continue;
                    type.getAnnotations().add((Node)annotationExpr);
                }
                type.getAnnotations().clear();
                type.getAnnotations().addAll(type2.getAnnotations());
                if (type.getName().getId().equals(type2.getName().getId())) {
                    if (!type.getJavadocComment().isPresent()) {
                        type.setJavadocComment((JavadocComment)type2.getJavadocComment().orElse(null));
                    }
                    for (FieldDeclaration field : type2.getFields()) {
                        name = field.getVariable(0).getName().getId();
                        if ("serialVersionUID".equals(name)) continue;
                        FieldDeclaration editField = type.getFieldByName(name).orElse(null);
                        if (editField == null) {
                            editField = type.addField(field.getCommonType(), name, (Modifier.Keyword[])field.getModifiers().stream().map(Modifier::getKeyword).toArray(Modifier.Keyword[]::new));
                        }
                        editField.setVariables(field.getVariables());
                        editField.setComment((Comment)field.getComment().orElse(null));
                        editField.setAnnotations(field.getAnnotations());
                        editField.setJavadocComment((JavadocComment)field.getJavadocComment().orElse(null));
                    }
                    for (MethodDeclaration method : type2.getMethods()) {
                        boolean isEquals;
                        name = method.getName().getId();
                        MethodDeclaration editMethod = type.getMethodsByName(name).stream().findAny().orElse(null);
                        if (type.getMethodsByName(name).size() > 1 || type2.getMethodsByName(name).size() > 1) break;
                        if (editMethod == null) {
                            editMethod = type.addMethod(method.getName().getId(), (Modifier.Keyword[])method.getModifiers().stream().map(Modifier::getKeyword).toArray(Modifier.Keyword[]::new));
                            editMethod.setBody((BlockStmt)method.getBody().orElse(null));
                            editMethod.setParameters(method.getParameters());
                            editMethod.setComment((Comment)method.getComment().orElse(null));
                            editMethod.setAnnotations(method.getAnnotations());
                            editMethod.setType(method.getType());
                            editMethod.setJavadocComment((JavadocComment)method.getJavadocComment().orElse(null));
                        }
                        BlockStmt block1 = editMethod.getBody().orElse(null);
                        BlockStmt block2 = method.getBody().orElse(null);
                        boolean bl = isEquals = block1 == null && block2 == null || block2 != null && block1 != null && block2.toString().replaceAll(" +", "").replaceAll("\n", "").equals(block1.toString().replaceAll(" +", "").replaceAll("\n", ""));
                        if (editMethod.getParameters().stream().anyMatch(parameter -> parameter.getType().asString().contains(tableVo.getClassName())) || method.getParameters().size() != editMethod.getParameters().size()) break;
                        if (isEquals) {
                            editMethod.setBody((BlockStmt)method.getBody().orElse(null));
                        }
                        editMethod.setParameters(method.getParameters());
                        editMethod.setComment((Comment)method.getComment().orElse(null));
                        editMethod.setAnnotations(method.getAnnotations());
                        editMethod.setType(method.getType());
                        editMethod.setJavadocComment((JavadocComment)method.getJavadocComment().orElse(null));
                    }
                }
                System.out.println("edit file " + fullName);
                FileWriter writer = new FileWriter(file, false);
                writer.write(value.toString());
                ((Writer)writer).close();
                fileTemp.delete();
                continue;
            }
            System.out.println("create file " + fullName);
            this.printFile(center, tableVo, filePath, file);
            if (!fullName.endsWith(".java")) continue;
            ParseResult result = this.javaParser.parse(file);
            CompilationUnit value = result.getResult().orElse(null);
            System.out.println("edit file " + fullName);
            FileWriter writer = new FileWriter(file, false);
            writer.write(Objects.requireNonNull(value).toString());
            ((Writer)writer).close();
        }
    }

    private boolean compare(NodeList<Parameter> parameters1, NodeList<Parameter> parameters2) {
        int parameters1Size = parameters1.size();
        for (int i = 0; i < parameters1Size; ++i) {
            Parameter parameter = (Parameter)parameters1.get(i);
            Parameter parameter2 = (Parameter)parameters2.get(i);
            if (parameter.getName().getId().equals(parameter2.getName().getId())) continue;
            return false;
        }
        return true;
    }

    private void printFile(CenterDto center, TableVo tableVo, String filePath, File file) throws IOException, TemplateException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        FileUtils.printFile(filePath, this.loadTemplateData(center, tableVo), fileOutputStream);
    }
}

