package net.luohuasheng.bee.jdbc.generate.utils;

import com.fasterxml.jackson.databind.*;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsFactory;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import net.luohuasheng.bee.jdbc.generate.model.GeneratorDto;
import net.luohuasheng.bee.proxy.core.exception.JsonException;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author wusuoming
 */
public class GeneratorUtils {
    private static final String[] PROPERTIES_FILE_NAMES = new String[]{"config/generator.yml", "config/generator.xml", "config/generator.properties"};

    public static GeneratorDto load() {
        ObjectMapper mapper = null;
        String result = null;
        for (int i = 0; i < PROPERTIES_FILE_NAMES.length; i++) {
            String fileName = PROPERTIES_FILE_NAMES[i];
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
            if (in != null) {
                result = new BufferedReader(new InputStreamReader(in)).lines().parallel().collect(Collectors.joining(System.lineSeparator()));
                if (i == 2) {
                    mapper = new ObjectMapper(JavaPropsFactory.builder().build());
                    result = result.replaceAll("lhs.generator.", "");
                } else if (i == 0) {
                    result = result.replace("lhs:\n", "").trim().replace("generator:\n", "");
                    mapper = new ObjectMapper(YAMLFactory.builder().build());
                } else {
                    result = result.replace("<lhs>\n", "").replace("</lhs>\n", "").replace("</generator>\n", "").replace("<generator>\n", "");
                    mapper = new ObjectMapper(XmlFactory.builder().build());
                }
                break;
            }
        }
        try {
            Objects.requireNonNull(mapper).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            mapper.setPropertyNamingStrategy(PropertyNamingStrategies.KEBAB_CASE);

            return mapper.readValue(result, GeneratorDto.class);
        } catch (Exception e) {
            throw new JsonException(e);
        }

    }

}
