package net.luohuasheng.bee.jdbc.generate.model;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author wusuoming
 */
public class CenterDto {

    private String name;
    private String code;
    private Integer port;

    private String description;
    private DataSourceDto datasource;
    private Map<String, String> extend;
    private Set<String> modules;

    public CenterDto() {
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DataSourceDto getDatasource() {
        return datasource;
    }

    public void setDatasource(DataSourceDto datasource) {
        this.datasource = datasource;
    }

    public Map<String, String> getExtend() {
        return GeneratorDto.replace(extend);
    }

    public void setExtend(Map<String, String> extend) {
        this.extend = extend;
    }


    public Set<String> getModules() {
        return modules;
    }

    public void setModules(String modules) {
        this.modules = Arrays.stream(modules.toLowerCase().split(",")).collect(Collectors.toSet());
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getPort() {
        return port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }
}
