/*
 * Decompiled with CFR 0.152.
 */
package net.luohuasheng.bee.jdbc.generate.utils;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FileUtils {
    private static final String IGNORE = ".include";

    public static List<String> readDir(String filePath, List<String> files) {
        File file;
        if (files == null) {
            files = new ArrayList<String>();
        }
        if ((file = new File(filePath)).isHidden()) {
            return new ArrayList<String>();
        }
        if (!file.isDirectory()) {
            if (!filePath.endsWith(IGNORE)) {
                files.add(filePath);
            }
        } else if (file.list() != null) {
            for (String fileName : Objects.requireNonNull(file.list())) {
                FileUtils.readDir(filePath + "/" + fileName, files);
            }
        }
        ArrayList<String> outs = new ArrayList<String>();
        for (String fileName : files) {
            outs.add(fileName.replace(filePath, ""));
        }
        return outs;
    }

    public static void printFile(String filePath, Map<String, Object> root, FileOutputStream output) throws IOException, TemplateException {
        File file = new File(filePath);
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_28);
        cfg.setDirectoryForTemplateLoading(file.getParentFile());
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setWrapUncheckedExceptions(true);
        Template temp = cfg.getTemplate(file.getName(), StandardCharsets.UTF_8.name());
        OutputStreamWriter out = new OutputStreamWriter(output);
        temp.process(root, (Writer)out);
    }

    public static String printFileName(String fileName, Map<String, Object> root) throws IOException, TemplateException {
        StringTemplateLoader stringLoader = new StringTemplateLoader();
        stringLoader.putTemplate("fileName", fileName);
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_28);
        cfg.setTemplateLoader((TemplateLoader)stringLoader);
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setWrapUncheckedExceptions(true);
        Template temp = cfg.getTemplate("fileName", StandardCharsets.UTF_8.name());
        StringWriter writer = new StringWriter();
        temp.process(root, (Writer)writer);
        return writer.toString();
    }
}

