package net.luohuasheng.bee.jdbc.generate.utils.typemapping;


import net.luohuasheng.bee.proxy.core.enums.DataType;

/**
 * 数据类型格式化
 *
 * @author wusuoming
 */
public class DatabaseDataTypesUtils {


    public static boolean isFloatNumber(String javaType) {
        if (javaType.endsWith("Float") || javaType.endsWith("Double") || javaType.endsWith("BigDecimal") || javaType.endsWith("BigInteger")) {
            return true;
        }
        if (javaType.endsWith("float") || javaType.endsWith("double") || javaType.endsWith("BigDecimal") || javaType.endsWith("BigInteger")) {
            return true;
        }
        return false;
    }

    public static boolean isIntegerNumber(String javaType) {
        if (javaType.endsWith("Long") || javaType.endsWith("Integer") || javaType.endsWith("Short") || javaType.endsWith("Byte") || javaType.endsWith("Boolean")) {
            return true;
        }
        if (javaType.endsWith("long") || javaType.endsWith("int") || javaType.endsWith("short") || javaType.endsWith("byte") || javaType.endsWith("boolean")) {
            return true;
        }
        return false;
    }

    public static boolean isDate(String javaType) {
        if (javaType.endsWith("Date")) {
            return true;
        }
        return false;
    }

    public static boolean isString(String javaType) {
        if (javaType.endsWith("String")) {
            return true;
        }
        return false;
    }

    public static String getPreferredJavaType(int sqlType, int size,
                                              int decimalDigits) {
        if (sqlType == DataType.INTEGER.getDataCategory()) {
            if (size == 1) {
                return "java.lang.Boolean";
            } else if (size < 3) {
                return "java.lang.Byte";
            } else if (size < 5) {
                return "java.lang.Short";
            } else if (size < 10) {
                return "java.lang.Integer";
            } else {
                return "java.lang.Long";
            }
        } else if (sqlType == DataType.DECIMAL.getDataCategory()) {
            return "java.lang.Double";
        } else if (sqlType == DataType.DATE.getDataCategory() || sqlType == DataType.DATE_TIME.getDataCategory()) {
            return "java.util.Date";
        } else {
            return "java.lang.String";

        }


    }


}
