/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.promise;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import net.lulihu.ObjectKit.StrKit;

public class Promise<V>
implements Future<V> {
    private final CountDownLatch taskLock = new CountDownLatch(1);
    private List<Action<Promise<V>>> callbacks = new ArrayList<Action<Promise<V>>>();
    private V result = null;
    protected Throwable exception = null;
    private boolean invoked = false;

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.invoked;
    }

    public V getOrNull() {
        return this.result;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        this.taskLock.await();
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.taskLock.await(timeout, unit)) {
            throw new TimeoutException(StrKit.format("\u627f\u8bfa\u5728 {} {} \u672a\u80fd\u505a\u5230", new Object[]{timeout, unit}));
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }

    void invoke(V result) {
        this.invokeWithResultOrException(result, null);
    }

    void invokeWithException(Throwable t) {
        this.invokeWithResultOrException(null, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeWithResultOrException(V result, Throwable t) {
        Promise promise = this;
        synchronized (promise) {
            if (this.invoked) {
                return;
            }
            this.invoked = true;
            this.result = result;
            this.exception = t;
            this.taskLock.countDown();
        }
        for (Action action : this.callbacks) {
            action.invoke(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRedeem(Action<Promise<V>> callback) {
        Promise promise = this;
        synchronized (promise) {
            if (!this.invoked) {
                this.callbacks.add(callback);
            }
        }
        if (this.invoked) {
            callback.invoke(this);
        }
    }

    public static <T> Promise<List<T>> waitAll(Promise<T> ... promises) {
        return Promise.waitAll(Arrays.asList(promises));
    }

    public static <T> Promise<List<T>> waitAll(final Collection<Promise<T>> promises) {
        final CountDownLatch waitAllLock = new CountDownLatch(promises.size());
        Promise result = new Promise<List<T>>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                boolean r = true;
                for (Promise f : promises) {
                    r &= f.cancel(mayInterruptIfRunning);
                }
                return r;
            }

            @Override
            public boolean isCancelled() {
                boolean r = true;
                for (Promise f : promises) {
                    r &= f.isCancelled();
                }
                return r;
            }

            @Override
            public boolean isDone() {
                boolean r = true;
                for (Promise f : promises) {
                    r &= f.isDone();
                }
                return r;
            }

            @Override
            public List<T> get() throws InterruptedException, ExecutionException {
                waitAllLock.await();
                ArrayList r = new ArrayList();
                for (Promise f : promises) {
                    r.add(f.get());
                }
                return r;
            }

            @Override
            public List<T> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                if (!waitAllLock.await(timeout, unit)) {
                    throw new TimeoutException(String.format("Promises didn't redeem in %s %s", new Object[]{timeout, unit}));
                }
                return this.get();
            }
        };
        Action action = completed -> {
            waitAllLock.countDown();
            if (waitAllLock.getCount() == 0L) {
                try {
                    result.invoke(result.get());
                }
                catch (Exception e) {
                    result.invokeWithException(e);
                }
            }
        };
        if (promises.isEmpty()) {
            result.invoke(Collections.emptyList());
        } else {
            for (Promise<T> f : promises) {
                f.onRedeem(action);
            }
        }
        return result;
    }

    public static <V> Promise<V> pure(V v) {
        Promise<V> p = new Promise<V>();
        p.invoke(v);
        return p;
    }

    public static <V> Promise<V> wrap(Throwable t) {
        Promise<V> p = new Promise<V>();
        p.invokeWithException(t);
        return p;
    }

    public <R> Promise<R> bind(Function<V, Promise<R>> function) {
        Promise result = new Promise();
        this.onRedeem(callback -> {
            try {
                Object v = callback.get();
                Promise applicationResult = (Promise)function.apply(v);
                applicationResult.onRedeem(applicationCallback -> {
                    try {
                        Object r = applicationCallback.get();
                        result.invoke(r);
                    }
                    catch (Throwable e) {
                        result.invokeWithException(e);
                    }
                });
            }
            catch (Throwable e) {
                result.invokeWithException(e);
            }
        });
        return result;
    }

    public static <T, R> Function<Promise<T>, Promise<R>> fmap(Function<T, R> function) {
        return p -> {
            Promise result = new Promise();
            p.onRedeem(callback -> {
                try {
                    Object t = callback.get();
                    Object r = function.apply(t);
                    result.invoke(r);
                }
                catch (Throwable e) {
                    result.invokeWithException(e);
                }
            });
            return result;
        };
    }

    public static <T> Promise<T> join(Promise<Promise<T>> promise) {
        Promise result = new Promise();
        promise.onRedeem(callback -> {
            try {
                Promise inner = (Promise)callback.get();
                inner.onRedeem(innerCallback -> {
                    try {
                        Object t = innerCallback.get();
                        result.invoke(t);
                    }
                    catch (InterruptedException | ExecutionException e) {
                        result.invokeWithException(e);
                    }
                });
            }
            catch (InterruptedException | ExecutionException e) {
                result.invokeWithException(e);
            }
        });
        return result;
    }

    public static <T, R> Function<T, Promise<R>> lift(Function<T, R> function) {
        return function.andThen(Promise::pure);
    }

    public static <T> Function<T, Promise<Void>> lift(Consumer<T> consumer) {
        return t -> {
            consumer.accept(t);
            return Promise.pure(null);
        };
    }

    public static interface Action<T> {
        public void invoke(T var1);
    }
}

