/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.office.excel;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.lulihu.Assert0;

public class ExcelReadHandle {
    private Map<String, Integer> nameData;
    private List<List<String>> data;
    private int size;

    public ExcelReadHandle(List<List<String>> data) {
        Assert0.toolBox().notNull(data, "\u6570\u636e\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        AtomicInteger i = new AtomicInteger(-1);
        this.nameData = data.remove(0).stream().collect(Collectors.toMap(Function.identity(), v -> i.incrementAndGet()));
        this.data = data;
        this.size = data.size();
    }

    public void forEachRow(BiConsumer<ExcelReadHandle, ? super Integer> action) {
        Objects.requireNonNull(action);
        for (int i = 0; i < this.size; ++i) {
            action.accept(this, (Integer)i);
        }
    }

    public void forEachRowData(BiConsumer<ExcelReadHandle, ? super List<String>> action) {
        Objects.requireNonNull(action);
        for (int i = 0; i < this.size; ++i) {
            action.accept(this, this.data.get(i));
        }
    }

    public String getValue(int row, String key) {
        if (this.size < row) {
            return null;
        }
        return this.getValue(this.data.get(row), key);
    }

    public String getValue(List<String> rowData, String key) {
        Integer col = this.nameData.get(key);
        if (col == null) {
            return null;
        }
        if (rowData.size() <= col) {
            return null;
        }
        return rowData.get(col);
    }
}

