/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.office.excel;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import net.lulihu.dateTime.DateTimeKit;
import net.lulihu.dateTime.Timer;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelAnalysis {
    private static final Logger log = LoggerFactory.getLogger(ExcelAnalysis.class);
    private static final String DataValidationError1 = "\u63d0\u793a\u4fe1\u606f\uff1a";
    private static final String DataValidationError2 = "\u6570\u636e\u4e0d\u89c4\u8303\uff0c\u8bf7\u9009\u62e9\u8868\u683c\u4e0b\u62c9\u5217\u8868\u4e2d\u7684\u6570\u636e\uff01";
    private static final ThreadLocal<DecimalFormat> df = new ThreadLocal();
    private static final String MESSAGE_FORMAT_df = "#.###";
    private List<List<String[]>> dataLists;
    private String[] sheetName;
    private String[] labelName;
    private HttpServletResponse response;
    private HashMap notBorderMap;
    private HashMap regionMap;
    private HashMap columnMap;
    private HashMap styles;
    private HashMap paneMap;
    private HashMap rowStyles;
    private HashMap columnStyles;
    private HashMap dropDownMap;
    private String fileName;
    private String filePath = this.getFilePath();

    private static DecimalFormat getDecimalFormat() {
        DecimalFormat format = df.get();
        if (format == null) {
            format = new DecimalFormat(MESSAGE_FORMAT_df);
            df.set(format);
        }
        return format;
    }

    public ExcelAnalysis() {
        this.dataLists = this.getDataLists();
        this.response = this.getResponse();
        this.notBorderMap = this.getNotBorderMap();
        this.regionMap = this.getRegionMap();
        this.columnMap = this.getColumnMap();
        this.styles = this.getStyles();
        this.paneMap = this.getPaneMap();
        this.fileName = this.getFileName();
        this.sheetName = this.getSheetName();
        this.labelName = this.getLabelName();
        this.rowStyles = this.getRowStyles();
        this.columnStyles = this.getColumnStyles();
        this.dropDownMap = this.getDropDownMap();
    }

    public void exportForExcelsOptimize() throws Exception {
        ExcelAnalysis.exportForExcel(this.response, this.dataLists, this.notBorderMap, this.regionMap, this.columnMap, this.styles, this.paneMap, this.fileName, this.sheetName, this.labelName, this.rowStyles, this.columnStyles, this.dropDownMap);
    }

    public static void exportForExcel(HttpServletResponse response, List<List<String[]>> dataLists, HashMap notBorderMap, HashMap regionMap, HashMap columnMap, HashMap styles, HashMap paneMap, String fileName, String[] sheetName, String[] labelName, HashMap rowStyles, HashMap columnStyles, HashMap dropDownMap) throws Exception {
        boolean debugEnabled = log.isDebugEnabled();
        Timer timer = null;
        if (debugEnabled) {
            timer = DateTimeKit.timer();
        }
        SXSSFWorkbook sxssfWorkbook = new SXSSFWorkbook(1000);
        ExcelAnalysis.setDataList(sxssfWorkbook, dataLists, notBorderMap, regionMap, columnMap, styles, paneMap, sheetName, labelName, rowStyles, columnStyles, dropDownMap);
        ExcelAnalysis.setIo(sxssfWorkbook, fileName, sheetName, response, null);
        if (debugEnabled) {
            log.debug("Excel\u5bfc\u51fa\u8fd0\u884c\u65f6 :  " + timer.duration() + " ms");
        }
    }

    public static LinkedHashMap<String, List<List<String>>> importForExcelData(Workbook book, HashMap<Integer, Integer[]> continueRowMap) {
        long startTime = System.currentTimeMillis();
        try {
            LinkedHashMap<String, List<List<String>>> returnDataList = new LinkedHashMap<String, List<List<String>>>();
            int sheetNumber = book.getNumberOfSheets();
            for (int k = 0; k < sheetNumber; ++k) {
                int irow;
                Sheet sheet = book.getSheetAt(k);
                int rowCount = sheet.getLastRowNum() + 1;
                ArrayList rowListValue = new ArrayList();
                for (int i = irow = 0; i < rowCount; ++i) {
                    Integer[] continueRow;
                    Row valueRow = sheet.getRow(i);
                    if (valueRow == null) continue;
                    if (continueRowMap != null && (continueRow = continueRowMap.get(k + 1)) != null) {
                        int continueRowCount = 0;
                        for (int w = 0; w <= continueRow.length - 1; ++w) {
                            Cell valueRowCell = valueRow.getCell(continueRow[w] - 1);
                            if (valueRowCell != null && !ExcelAnalysis.isBlank(valueRowCell.toString())) continue;
                            ++continueRowCount;
                        }
                        if (continueRowCount == continueRow.length) continue;
                    }
                    ArrayList<String> cellHashMap = new ArrayList<String>();
                    for (int j = 0; j < valueRow.getLastCellNum(); ++j) {
                        cellHashMap.add(ExcelAnalysis.getCellVal(valueRow.getCell(j)));
                    }
                    if (cellHashMap.size() <= 0) continue;
                    rowListValue.add(cellHashMap);
                }
                returnDataList.put(sheet.getSheetName(), rowListValue);
            }
            System.out.println("======= Excel\u5bfc\u5165\u8fd0\u884c\u65f6:  " + (System.currentTimeMillis() - startTime) + " ms");
            return returnDataList;
        }
        catch (Exception e) {
            log.error("Excel\u5bfc\u5165\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    private static void setDataList(SXSSFWorkbook sxssfWorkbook, List<List<String[]>> dataLists, HashMap notBorderMap, HashMap regionMap, HashMap columnMap, HashMap styles, HashMap paneMap, String[] sheetName, String[] labelName, HashMap rowStyles, HashMap columnStyles, HashMap dropDownMap) throws Exception {
        if (dataLists == null) {
            throw new IOException("=======  Excel\u8f93\u51fa\u89e3\u6790\u5f02\u5e38\u6d88\u606f\uff1a\u5bfc\u51fa\u6570\u636e\uff08\u7c7b\u578b\uff1aList <List <String [] >>\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (sheetName == null) {
            throw new IOException("=======  Excel\u8f93\u51fa\u89e3\u6790\u5f02\u5e38\u6d88\u606f\uff1a\u5bfc\u51fa\u8868\uff08\u7c7b\u578b\uff1aString []\uff09\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        int k = 0;
        for (List<String[]> list : dataLists) {
            SXSSFRow sxssfRow;
            SXSSFSheet sxssfSheet = sxssfWorkbook.createSheet();
            sxssfSheet.setDefaultColumnWidth(16);
            sxssfWorkbook.setSheetName(k, sheetName[k]);
            int jRow = 0;
            if (labelName != null) {
                sxssfRow = sxssfSheet.createRow(jRow);
                Cell cell = CellUtil.createCell((Row)sxssfRow, (int)jRow, (String)labelName[k]);
                ExcelAnalysis.setMergedRegion(sxssfSheet, 0, 0, 0, list.get(0).length - 1);
                ExcelAnalysis.setExcelStyles(cell, sxssfWorkbook, sxssfRow, 16, true, true, false, false, false, null, 399);
                jRow = 1;
            }
            if (regionMap != null) {
                ExcelAnalysis.setMergedRegion(sxssfSheet, (ArrayList)regionMap.get(k + 1));
            }
            if (dropDownMap != null) {
                ExcelAnalysis.setDataValidation(sxssfSheet, (List)dropDownMap.get(k + 1), list.size());
            }
            if (columnMap != null) {
                ExcelAnalysis.setColumnWidth(sxssfSheet, (HashMap)columnMap.get(k + 1));
            }
            int pane = 1;
            if (paneMap != null) {
                pane = (Integer)paneMap.get(k + 1) + (labelName != null ? 1 : 0);
                ExcelAnalysis.createFreezePane(sxssfSheet, pane);
            }
            for (String[] listValue : list) {
                int columnIndex = 0;
                sxssfRow = sxssfSheet.createRow(jRow);
                for (int j = 0; j < listValue.length; ++j) {
                    SXSSFCell cells = sxssfRow.createCell(j);
                    Cell cell = CellUtil.createCell((Row)sxssfRow, (int)columnIndex, (String)listValue[j]);
                    ++columnIndex;
                    ExcelAnalysis.setExcelStyles(notBorderMap, cell, sxssfWorkbook, sxssfRow, k, jRow);
                    if (columnStyles != null && jRow >= pane) {
                        ExcelAnalysis.setExcelCellStyles(cell, sxssfWorkbook, sxssfRow, (List)columnStyles.get(k + 1), j);
                    }
                    if (rowStyles != null) {
                        ExcelAnalysis.setExcelCellStyles(cell, sxssfWorkbook, sxssfRow, (List)rowStyles.get(k + 1), jRow);
                    }
                    if (styles == null) continue;
                    ExcelAnalysis.setExcelStyles((Cell)cells, sxssfWorkbook, sxssfRow, (List)styles.get(k + 1), j, jRow);
                }
                ++jRow;
            }
            ++k;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setIo(SXSSFWorkbook sxssfWorkbook, String fileName, String[] sheetName, HttpServletResponse response, String filePath) throws Exception {
        OutputStream outputStream = null;
        try {
            if (response != null) {
                response.setHeader("Charset", "UTF-8");
                response.setHeader("Content-Type", "application/vnd.ms-excel");
                response.setHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(fileName == null ? sheetName[0] : fileName, "utf8") + ".xlsx");
                response.flushBuffer();
                outputStream = response.getOutputStream();
            } else if (filePath != null) {
                outputStream = new FileOutputStream(filePath);
            }
            if (outputStream != null) {
                sxssfWorkbook.write(outputStream);
                sxssfWorkbook.dispose();
            }
        }
        catch (Exception e) {
            log.error("\u8f93\u51fa\u6d41\u4e0d\u4e3a\u7a7a", (Throwable)e);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isBlank(String str) {
        int strLen;
        if (str != null && (strLen = str.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    private static void createFreezePane(SXSSFSheet sxssfSheet, Integer row) {
        if (row != null && row > 0) {
            sxssfSheet.createFreezePane(0, row.intValue(), 0, 1);
        }
    }

    private static void setColumnWidth(SXSSFSheet sxssfSheet, HashMap map) {
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                Object key = entry.getKey();
                Object val = entry.getValue();
                sxssfSheet.setColumnWidth(((Integer)key).intValue(), (Integer)val * 512);
            }
        }
    }

    private static void setMergedRegion(SXSSFSheet sheet, ArrayList<Integer[]> rowColList) {
        if (rowColList != null && rowColList.size() > 0) {
            for (Integer[] str : rowColList) {
                if (str.length != 4) continue;
                Integer firstRow = str[0];
                Integer lastRow = str[1];
                Integer firstCol = str[2];
                Integer lastCol = str[3];
                ExcelAnalysis.setMergedRegion(sheet, firstRow, lastRow, firstCol, lastCol);
            }
        }
    }

    private static void setMergedRegion(SXSSFSheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        sheet.addMergedRegion(new CellRangeAddress(firstRow, lastRow, firstCol, lastCol));
    }

    private static void setDataValidation(SXSSFSheet sheet, List<String[]> dropDownListData, int dataListSize) {
        if (dropDownListData.size() > 0) {
            for (int col = 0; col < dropDownListData.get(0).length; ++col) {
                Integer colv = Integer.parseInt(dropDownListData.get(0)[col]);
                ExcelAnalysis.setDataValidation(sheet, dropDownListData.get(col + 1), 1, dataListSize < 100 ? 500 : dataListSize, colv, colv);
            }
        }
    }

    private static void setDataValidation(SXSSFSheet xssfWsheet, String[] list, Integer firstRow, Integer lastRow, Integer firstCol, Integer lastCol) {
        DataValidationHelper helper = xssfWsheet.getDataValidationHelper();
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow.intValue(), lastRow.intValue(), firstCol.intValue(), lastCol.intValue());
        DataValidationConstraint constraint = helper.createExplicitListConstraint(list);
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        dataValidation.createErrorBox(DataValidationError1, DataValidationError2);
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        xssfWsheet.addValidationData(dataValidation);
    }

    private static void setExcelStyles(HashMap notBorderMap, Cell cell, SXSSFWorkbook wb, SXSSFRow sxssfRow, int k, int jRow) {
        boolean border = true;
        if (notBorderMap != null) {
            Integer[] borderInt;
            for (Integer integer : borderInt = (Integer[])notBorderMap.get(k + 1)) {
                if (integer != jRow) continue;
                border = false;
            }
        }
        ExcelAnalysis.setExcelStyles(cell, wb, sxssfRow, null, null, true, border, false, false, null, null);
    }

    private static void setExcelStyles(Cell cell, SXSSFWorkbook wb, SXSSFRow sxssfRow, Integer fontSize, Boolean bold, Boolean center, Boolean isBorder, Boolean leftBoolean, Boolean rightBoolean, Integer fontColor, Integer height) {
        CellStyle cellStyle = wb.createCellStyle();
        if (center != null && center.booleanValue()) {
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        }
        if (rightBoolean != null && rightBoolean.booleanValue()) {
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyle.setAlignment(HorizontalAlignment.RIGHT);
        }
        if (leftBoolean != null && leftBoolean.booleanValue()) {
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyle.setAlignment(HorizontalAlignment.LEFT);
        }
        if (isBorder != null && isBorder.booleanValue()) {
            ExcelAnalysis.setBorder(cellStyle, isBorder);
        }
        XSSFFont font = (XSSFFont)wb.createFont();
        if (bold != null && bold.booleanValue()) {
            font.setBold(bold.booleanValue());
        }
        if (height != null) {
            sxssfRow.setHeight((short)(height * 2));
        }
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeight(fontSize == null ? 12.0 : (double)fontSize.intValue());
        cellStyle.setFont((Font)font);
        font.setColor(IndexedColors.fromInt((int)(fontColor == null ? 8 : fontColor.intValue())).index);
        cell.setCellStyle(cellStyle);
    }

    private static void setExcelCellStyles(Cell cell, SXSSFWorkbook wb, SXSSFRow sxssfRow, List<Object[]> rowStyleList, int rowIndex) {
        if (rowStyleList != null && rowStyleList.size() > 0) {
            Integer[] rowStyle;
            for (Integer index : rowStyle = (Integer[])rowStyleList.get(1)) {
                if (rowIndex != index) continue;
                Boolean[] bool = (Boolean[])rowStyleList.get(0);
                Integer fontColor = null;
                Integer fontSize = null;
                Integer height = null;
                if (rowStyleList.size() >= 3) {
                    int length = rowStyleList.get(2).length;
                    fontColor = (Integer)rowStyleList.get(2)[0];
                    if (length >= 2) {
                        fontSize = (Integer)rowStyleList.get(2)[1];
                    }
                    if (length >= 3) {
                        height = (Integer)rowStyleList.get(2)[2];
                    }
                }
                ExcelAnalysis.setExcelStyles(cell, wb, sxssfRow, fontSize, bool[3], bool[0], bool[4], bool[2], bool[1], fontColor, height);
            }
        }
    }

    private static void setExcelStyles(Cell cell, SXSSFWorkbook wb, SXSSFRow sxssfRow, List<List<Object[]>> styles, int cellIndex, int rowIndex) {
        if (styles != null) {
            for (List<Object[]> stylesList : styles) {
                if (stylesList == null) continue;
                Boolean[] bool = (Boolean[])stylesList.get(0);
                Integer fontColor = null;
                Integer fontSize = null;
                Integer height = null;
                if (stylesList.size() >= 2) {
                    int leng = stylesList.get(1).length;
                    fontColor = (Integer)stylesList.get(1)[0];
                    if (leng >= 2) {
                        fontSize = (Integer)stylesList.get(1)[1];
                    }
                    if (leng >= 3) {
                        height = (Integer)stylesList.get(1)[2];
                    }
                }
                for (int m = 2; m < stylesList.size(); ++m) {
                    Integer[] str = (Integer[])stylesList.get(m);
                    if (cellIndex + 1 != str[1] || rowIndex + 1 != str[0]) continue;
                    ExcelAnalysis.setExcelStyles(cell, wb, sxssfRow, fontSize, bool[3], bool[0], bool[4], bool[2], bool[1], fontColor, height);
                }
            }
        }
    }

    private static void setBorder(CellStyle cellStyle, Boolean isBorder) {
        if (isBorder.booleanValue()) {
            cellStyle.setBorderBottom(BorderStyle.THIN);
            cellStyle.setBorderLeft(BorderStyle.THIN);
            cellStyle.setBorderTop(BorderStyle.THIN);
            cellStyle.setBorderRight(BorderStyle.THIN);
        }
    }

    private static String getCellVal(Cell cell) {
        String val;
        if (cell != null) {
            switch (cell.getCellTypeEnum()) {
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        val = DateTimeKit.NORM_DATE_FORMAT.get().format(cell.getDateCellValue());
                        break;
                    }
                    val = ExcelAnalysis.getDecimalFormat().format(cell.getNumericCellValue());
                    break;
                }
                case STRING: 
                case BLANK: {
                    val = cell.getStringCellValue();
                    break;
                }
                case BOOLEAN: {
                    val = String.valueOf(cell.getBooleanCellValue());
                    break;
                }
                case ERROR: {
                    val = "\u9519\u8bef";
                    break;
                }
                case FORMULA: {
                    try {
                        val = String.valueOf(cell.getStringCellValue());
                    }
                    catch (IllegalStateException e) {
                        val = String.valueOf(cell.getNumericCellValue());
                    }
                    break;
                }
                default: {
                    val = cell.getRichStringCellValue() == null ? "" : cell.getRichStringCellValue().toString();
                    break;
                }
            }
        } else {
            val = "";
        }
        return val;
    }

    public void setDataLists(List<List<String[]>> dataLists) {
        this.dataLists = dataLists;
    }

    public List<List<String[]>> getDataLists() {
        return this.dataLists;
    }

    public void setSheetName(String[] sheetName) {
        this.sheetName = sheetName;
    }

    public String[] getSheetName() {
        return this.sheetName;
    }

    public void setLabelName(String[] labelName) {
        this.labelName = labelName;
    }

    public String[] getLabelName() {
        return this.labelName;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setNotBorderMap(HashMap notBorderMap) {
        this.notBorderMap = notBorderMap;
    }

    public HashMap getNotBorderMap() {
        return this.notBorderMap;
    }

    public void setRegionMap(HashMap regionMap) {
        this.regionMap = regionMap;
    }

    public HashMap getRegionMap() {
        return this.regionMap;
    }

    public void setColumnMap(HashMap columnMap) {
        this.columnMap = columnMap;
    }

    public HashMap getColumnMap() {
        return this.columnMap;
    }

    public void setStyles(HashMap styles) {
        this.styles = styles;
    }

    public HashMap getStyles() {
        return this.styles;
    }

    public void setPaneMap(HashMap paneMap) {
        this.paneMap = paneMap;
    }

    public HashMap getPaneMap() {
        return this.paneMap;
    }

    public void setRowStyles(HashMap rowStyles) {
        this.rowStyles = rowStyles;
    }

    public HashMap getRowStyles() {
        return this.rowStyles;
    }

    public void setColumnStyles(HashMap columnStyles) {
        this.columnStyles = columnStyles;
    }

    public HashMap getColumnStyles() {
        return this.columnStyles;
    }

    public void setDropDownMap(HashMap dropDownMap) {
        this.dropDownMap = dropDownMap;
    }

    public HashMap getDropDownMap() {
        return this.dropDownMap;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFilePath() {
        return this.filePath;
    }
}

