/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.office.excel;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import net.lulihu.Assert0;
import net.lulihu.ObjectKit.CollectionKit;
import net.lulihu.ObjectKit.MapKit;
import net.lulihu.ObjectKit.ReflectKit;
import net.lulihu.exception.ToolBoxException;

public abstract class Excel {
    private List<List<String[]>> data;
    private String[] sheetName;
    private boolean hasAlias = true;

    public <D> Excel(List<D> data) {
        this("sheet1", data);
    }

    public <D> Excel(String sheetName, List<D> data) {
        this(sheetName, null, data);
    }

    public <D> Excel(String sheetName, LinkedHashMap<String, String> headerAlias, List<D> data) {
        this(new String[]{sheetName}, MapKit.isNotEmpty(headerAlias) ? Collections.singletonList(headerAlias) : null, Collections.singletonList(data));
    }

    public <D> Excel(String[] sheetName, List<LinkedHashMap<String, String>> headerAlias, List<List<D>> data) {
        Assert0.toolBox().notNull(data, "\u5199\u51faexcel\u6570\u636e\u4e3a\u7a7a");
        List sheetHeaderAlias = (List)CollectionKit.isEmpty(headerAlias, () -> CollectionKit.isEmpty(this.sheetHeaderAlias(), () -> this.defaultHeaderAlias(data)));
        this.data = this.dataFormat(data, sheetHeaderAlias);
        this.sheetName = sheetName;
    }

    private <D> List<List<String[]>> dataFormat(List<List<D>> data, List<LinkedHashMap<String, String>> headerAlias) {
        Assert0.toolBox().notTrue(data.size() != headerAlias.size(), "\u6570\u636esheet\u957f\u5ea6\u4e0e\u522b\u540dsheet\u957f\u5ea6\u4e0d\u4e00\u81f4");
        ArrayList<List<String[]>> result = new ArrayList<List<String[]>>();
        try {
            int xl = data.size();
            for (int x = 0; x < xl; ++x) {
                LinkedHashMap<String, String> alias = headerAlias.get(x);
                ArrayList<String> fieldNames = new ArrayList<String>(alias.keySet());
                int hl = fieldNames.size();
                ArrayList<String[]> sheet = new ArrayList<String[]>();
                if (this.hasAlias) {
                    sheet.add(alias.values().toArray(new String[0]));
                }
                for (D y : data.get(x)) {
                    String[] d = new String[hl];
                    for (int i = 0; i < hl; ++i) {
                        Object fieldValue = ReflectKit.getFieldValue(y, (String)fieldNames.get(i));
                        d[i] = Objects.toString(fieldValue);
                    }
                    sheet.add(d);
                }
                result.add(sheet);
            }
        }
        catch (IllegalAccessException e) {
            throw new ToolBoxException(e, "\u89e3\u6790\u5bfc\u51fa\u6570\u636e\u9519\u8bef", new Object[0]);
        }
        return result;
    }

    public String[] labelFirstMerge() {
        return null;
    }

    public List<LinkedHashMap<String, String>> sheetHeaderAlias() {
        return null;
    }

    private <D> List<LinkedHashMap<String, String>> defaultHeaderAlias(List<List<D>> data) {
        this.hasAlias = false;
        ArrayList<LinkedHashMap<String, String>> result = new ArrayList<LinkedHashMap<String, String>>();
        for (List<D> dd : data) {
            LinkedHashMap<String, String> headerAlias = new LinkedHashMap<String, String>();
            List<Field> fields = ReflectKit.getAllFieldsList(dd.get(0).getClass());
            for (Field field : fields) {
                String fieldName = field.getName();
                headerAlias.put(fieldName, fieldName);
            }
            result.add(headerAlias);
        }
        return result;
    }

    public List<List<String[]>> getData() {
        return this.data;
    }

    public String[] getSheetName() {
        return this.sheetName;
    }

    public void setHasAlias(boolean hasAlias) {
        this.hasAlias = hasAlias;
    }
}

