/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.lock;

import java.util.Map;
import java.util.concurrent.locks.Condition;
import net.lulihu.ObjectKit.LogKit;
import net.lulihu.dataStructure.LRULinkedHashMap;
import net.lulihu.exception.ToolBoxException;
import net.lulihu.lock.OrderExecuteLockKit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionLock {
    private static final Logger log = LoggerFactory.getLogger(ConditionLock.class);
    private final int incremental;
    private final OrderExecuteLockKit orderExecuteLock;
    private final Condition condition;

    ConditionLock(int incremental, Condition condition, OrderExecuteLockKit orderExecuteLock) {
        this.incremental = incremental;
        this.orderExecuteLock = orderExecuteLock;
        this.condition = condition;
    }

    public void getLock() {
        Map.Entry<Integer, Condition> currentCondition = this.getCurrentConditionMap();
        if (currentCondition == null) {
            return;
        }
        Integer incremental = currentCondition.getKey();
        if (this.incremental < incremental) {
            throw new ToolBoxException("\u5f53\u524d\u7ebf\u7a0b\u6301\u6709\u7684\u6761\u4ef6\u5df2\u7ecf\u88ab\u91ca\u653e...");
        }
        this.orderExecuteLock.getLock();
        boolean boo = true;
        do {
            if ((currentCondition = this.getCurrentConditionMap()) == null) {
                return;
            }
            incremental = currentCondition.getKey();
            if (!incremental.equals(this.incremental)) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    if (!Thread.interrupted()) continue;
                    LogKit.warn(log, "\u7ebf\u7a0b\u7b49\u5f85\u8fc7\u7a0b\u4e2d\u88ab\u6253\u65ad...");
                }
                continue;
            }
            boo = false;
        } while (boo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        Map.Entry<Integer, Condition> currentCondition = this.getCurrentConditionMap();
        if (currentCondition == null) {
            return;
        }
        Integer incremental = currentCondition.getKey();
        if (!incremental.equals(this.incremental)) {
            throw new ToolBoxException("\u5f53\u524d\u7ebf\u7a0b\u6301\u6709\u7684\u6761\u4ef6\u8fd8\u672a\u83b7\u53d6\u5230\u9501\u6216\u6761\u4ef6\u5df2\u7ecf\u88ab\u91ca\u653e...");
        }
        this.getIncrementalSignalMap().remove(incremental);
        try {
            Map.Entry<Integer, Condition> currentConditionMap = this.getCurrentConditionMap();
            if (currentConditionMap != null) {
                currentConditionMap.getValue().signalAll();
            }
        }
        finally {
            this.orderExecuteLock.unlock();
        }
    }

    private Map.Entry<Integer, Condition> getCurrentConditionMap() {
        LRULinkedHashMap<Integer, Condition> incrementalSignalMap = this.getIncrementalSignalMap();
        if (incrementalSignalMap.isEmpty()) {
            return null;
        }
        return incrementalSignalMap.getHead();
    }

    private LRULinkedHashMap<Integer, Condition> getIncrementalSignalMap() {
        return this.orderExecuteLock.getIncrementalSignalMap();
    }
}

