/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.jdbc.orm;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.List;
import java.util.Map;
import net.lulihu.ObjectKit.BeanKit;
import net.lulihu.ObjectKit.ClassKit;
import net.lulihu.ObjectKit.LogKit;
import net.lulihu.dateTime.DateTimeKit;
import net.lulihu.dateTime.Timer;
import net.lulihu.exception.ToolBoxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryResultSetKit {
    private static final Logger log = LoggerFactory.getLogger(QueryResultSetKit.class);
    private static final boolean debug = log.isDebugEnabled();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> putResultSet(ResultSet resultSet, List<T> result, Class<T> resultClass) throws Exception {
        Timer timer = null;
        if (debug) {
            timer = DateTimeKit.timer();
        }
        try {
            int resultType;
            if (BeanKit.isPrimitive(resultClass)) {
                resultType = 1;
            } else if (BeanKit.isBean(resultClass)) {
                resultType = 2;
            } else {
                throw new ToolBoxException("\u9519\u8bef\u7684\u8fd4\u56de\u503c\u7c7b\u578b\u3010{}\u3011", resultClass);
            }
            List<T> list = QueryResultSetKit.putResultSetToArray(resultType, resultSet, result, resultClass);
            return list;
        }
        finally {
            if (debug) {
                LogKit.debug(log, "\u67e5\u8be2\u5c01\u88c5\u8017\u65f6:{}/ms", (Object)timer.duration());
            }
        }
    }

    private static <T> List<T> putResultSetToArray(int resultType, ResultSet resultSet, List<T> result, Class<T> resultClass) throws Exception {
        ResultSetMetaData data = resultSet.getMetaData();
        if (resultType == 1) {
            while (resultSet.next()) {
                result.add(resultSet.getObject(1));
            }
        } else {
            Map<String, String> propertyMapping = BeanKit.getBeanPropertyName(resultClass);
            while (resultSet.next()) {
                result.add(QueryResultSetKit.putResultSet(resultClass, propertyMapping, resultSet, data));
            }
        }
        return result;
    }

    private static <T> T putResultSet(Class<T> resultClass, Map<String, String> propertyMapping, ResultSet resultSet, ResultSetMetaData data) throws Exception {
        T result = ClassKit.newInstance(resultClass);
        int count = data.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            String fieldName;
            String columnName = data.getColumnLabel(i);
            Object value = resultSet.getObject(columnName);
            if (value == null || (fieldName = propertyMapping.get(columnName)) == null) continue;
            Field targetField = BeanKit.getPropertyField(resultClass, fieldName);
            targetField.set(result, value);
        }
        return result;
    }
}

