/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.http.okhttp;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.lulihu.ObjectKit.FileKit;
import net.lulihu.exception.RequestException;
import net.lulihu.http.MIME;
import net.lulihu.http.okhttp.NoEncodeFormBody;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);
    private static final ThreadLocal<Integer> CONNECT_TIMEOUT = new ThreadLocal();
    private static final ThreadLocal<Integer> READ_TIMEOUT = new ThreadLocal();
    private static final ThreadLocal<Object> REQUEST_PARAM = new ThreadLocal();
    private static final ThreadLocal<Object> REQUEST_HEADER_PARAM = new ThreadLocal();

    public static void setTimeout(Integer connect, Integer read) {
        if (connect != null) {
            CONNECT_TIMEOUT.set(connect);
        }
        if (read != null) {
            READ_TIMEOUT.set(read);
        }
    }

    public static BufferedSource getResponseSource(String url) throws RequestException {
        Request request = new Request.Builder().url(url).build();
        try {
            Response response = HttpUtils.sendRequest(request);
            ResponseBody body = response.body();
            return body.source();
        }
        catch (IOException e) {
            throw new RequestException("\u8bf7\u6c42\u8def\u5f84\uff1a" + url + "\u5f02\u5e38\uff01:", e);
        }
    }

    public static boolean downloadSmallFile(String url, String filePath) throws RequestException {
        return HttpUtils.downloadSmallFile(url, new File(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean downloadSmallFile(String url, File file) throws RequestException {
        BufferedSink sink = null;
        BufferedSource source = null;
        try {
            source = HttpUtils.getResponseSource(url);
            sink = Okio.buffer((Sink)Okio.sink((File)FileKit.createFile(file)));
            sink.writeAll((Source)source);
            sink.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (sink != null) {
                try {
                    sink.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    private static void requestLog(Request request) {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)request.url());
            log.debug("\u8bf7\u6c42\u7c7b\u578b\uff1a{}", (Object)request.method());
            Object requestHeaderParam = REQUEST_HEADER_PARAM.get();
            log.debug("\u8bf7\u6c42\u5934\u90e8\u53c2\u6570\uff1a{}", (Object)(requestHeaderParam == null ? "" : JSON.toJSONString((Object)requestHeaderParam)));
            Object requestParam = REQUEST_PARAM.get();
            if (requestParam != null) {
                log.debug("\u8bf7\u6c42\u4e3b\u4f53\u53c2\u6570\uff1a{}", requestParam instanceof String ? requestParam : JSON.toJSONString((Object)requestParam));
            }
        }
    }

    private static Response sendRequest(Request request) throws RequestException, IOException {
        try {
            HttpUtils.requestLog(request);
            Integer connectTimeout = CONNECT_TIMEOUT.get();
            Integer readTimeout = READ_TIMEOUT.get();
            OkHttpClient client = new OkHttpClient.Builder().connectTimeout(connectTimeout == null ? 10L : (long)connectTimeout.intValue(), TimeUnit.SECONDS).readTimeout(readTimeout == null ? 10L : (long)readTimeout.intValue(), TimeUnit.SECONDS).build();
            long startTime = System.nanoTime();
            Response response = client.newCall(request).execute();
            if (log.isDebugEnabled()) {
                log.debug("\u8bf7\u6c42\u8017\u65f6:" + (System.nanoTime() - startTime) / 1000L + " /\u03bcs");
            }
            if (response.isSuccessful()) {
                Response response2 = response;
                return response2;
            }
            throw new RequestException(response.code(), response.message(), response.body().string());
        }
        finally {
            CONNECT_TIMEOUT.remove();
            READ_TIMEOUT.remove();
            REQUEST_PARAM.remove();
            REQUEST_HEADER_PARAM.remove();
        }
    }

    private static <T> T packagingResult(Request request, Class<T> resultClazz) throws RequestException {
        try {
            Response response = HttpUtils.sendRequest(request);
            String result = response.body().string();
            if (log.isDebugEnabled()) {
                log.debug("\u8bf7\u6c42\u7ed3\u679c:\n {} ", (Object)result);
            }
            return (T)JSON.parseObject((String)result, resultClazz);
        }
        catch (IOException e) {
            throw new RequestException("\u53d1\u9001\u5730\u5740\u4e3a" + request.url() + "\u7684\u8bf7\u6c42\u9519\u8bef", e);
        }
    }

    private static void setPostParam(Map<String, String> params, MultipartBody.Builder multipartBodyBuilder) {
        if (params != null && params.size() > 0) {
            for (String key : params.keySet()) {
                multipartBodyBuilder.addFormDataPart(key, params.get(key));
            }
        }
    }

    private static void setPostParam(Map<String, String> params, FormBody.Builder builder) {
        if (params != null && params.size() > 0) {
            for (String key : params.keySet()) {
                builder.add(key, params.get(key));
            }
        }
    }

    private static Request.Builder setHeadParam(Request.Builder requestBuilder, Map<String, String> headParam) {
        REQUEST_HEADER_PARAM.set(headParam);
        if (headParam != null && headParam.size() > 0) {
            for (String key : headParam.keySet()) {
                requestBuilder.addHeader(key, headParam.get(key));
            }
        }
        return requestBuilder;
    }

    public static <T> T sendPOSTNoEncode(String url, Map<String, String> headParam, Map<String, String> params, Class<T> resultClazz) throws RequestException {
        REQUEST_PARAM.set(params);
        Request request = HttpUtils.setHeadParam(new Request.Builder().url(url).post((RequestBody)HttpUtils.getNoEncodeFormBody(params).build()), headParam).build();
        return HttpUtils.packagingResult(request, resultClazz);
    }

    private static NoEncodeFormBody.Builder getNoEncodeFormBody(Map<String, String> params) {
        NoEncodeFormBody.Builder builder = new NoEncodeFormBody.Builder();
        params.forEach(builder::add);
        return builder;
    }

    private static FormBody.Builder getFormBody(Map<String, String> params) {
        FormBody.Builder builder = new FormBody.Builder();
        HttpUtils.setPostParam(params, builder);
        return builder;
    }

    public static <T> T sendPOST(String url, Map<String, String> headParam, Map<String, String> params, Class<T> resultClazz) throws RequestException {
        REQUEST_PARAM.set(params);
        FormBody body = HttpUtils.getFormBody(params).build();
        return HttpUtils.sendPOST(url, headParam, (RequestBody)body, resultClazz);
    }

    private static <T> T sendPOST(String url, Map<String, String> headParam, RequestBody body, Class<T> resultClazz) throws RequestException {
        Request request = HttpUtils.setHeadParam(new Request.Builder().url(url).post(body), headParam).build();
        return HttpUtils.packagingResult(request, resultClazz);
    }

    public static <T> T sendPOSTJson(String url, Map<String, String> headParam, Map<String, ?> params, Class<T> resultClazz) throws RequestException {
        REQUEST_PARAM.set(params);
        return HttpUtils.sendPOSTJson(url, headParam, JSON.toJSONString(params), resultClazz);
    }

    public static <T> T sendPOSTJson(String url, Map<String, String> headParam, String params, Class<T> resultClazz) throws RequestException {
        REQUEST_PARAM.set(params);
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)params);
        return HttpUtils.sendPOST(url, headParam, body, resultClazz);
    }

    private static String setGetParam(String url, Map<String, String> param) {
        if (param != null && param.size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (String key : param.keySet()) {
                builder.append(key).append("=").append(param.get(key)).append("&");
            }
            url = url + "?" + builder.toString().substring(0, builder.length() - 1);
        }
        return url;
    }

    public static <T> T sendGET(String url, Map<String, String> headParam, Map<String, String> param, Class<T> resultClazz) throws RequestException {
        Request request = HttpUtils.setHeadParam(new Request.Builder().url(HttpUtils.setGetParam(url, param)).get(), headParam).build();
        return HttpUtils.packagingResult(request, resultClazz);
    }

    public static <T> T sendPostMultipart(String reqUrl, Map<String, String> headParam, Map<String, String> params, String picKey, List<File> files, Class<T> resultClazz) throws RequestException {
        MultipartBody.Builder multipartBodyBuilder = new MultipartBody.Builder();
        multipartBodyBuilder.setType(MultipartBody.FORM);
        HttpUtils.setPostParam(params, multipartBodyBuilder);
        if (files != null) {
            for (File file : files) {
                String sux = HttpUtils.getMimeType(file.getName());
                MediaType mediaType = MediaType.parse((String)MIME.getMimeType(sux));
                multipartBodyBuilder.addFormDataPart(picKey, file.getName(), RequestBody.create((MediaType)mediaType, (File)file));
            }
        }
        Request request = HttpUtils.setHeadParam(new Request.Builder().url(reqUrl).post((RequestBody)multipartBodyBuilder.build()), headParam).build();
        return HttpUtils.packagingResult(request, resultClazz);
    }

    private static String getMimeType(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }
}

