/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.http.builder;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.lulihu.ObjectKit.StrKit;
import net.lulihu.http.MIME;
import net.lulihu.http.builder.HttpBuilder;
import net.lulihu.http.builder.HttpRequestException;
import net.lulihu.http.builder.RequestInterceptor;
import net.lulihu.http.builder.ResponseInterceptor;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class HttpPostMultipartBuilder
extends HttpBuilder {
    private MultipartBody.Builder builder = new MultipartBody.Builder();

    HttpPostMultipartBuilder(String url) {
        super(url);
    }

    public HttpPostMultipartBuilder addParam(String key, String value) {
        this.builder.addFormDataPart(key, value);
        return this;
    }

    public HttpPostMultipartBuilder addParam(String key, List<File> files) {
        for (File file : files) {
            this.addParam(key, file);
        }
        return this;
    }

    public HttpPostMultipartBuilder addParam(String key, File file) {
        String name = file.getName();
        String sux = StrKit.subSuf(name, name.lastIndexOf("."));
        MediaType mediaType = MediaType.parse((String)MIME.getMimeType(sux));
        this.builder.addFormDataPart(key, name, RequestBody.create((MediaType)mediaType, (File)file));
        return this;
    }

    @Override
    public HttpPostMultipartBuilder setHeader(Map<String, String> header) {
        super.setHeader(header);
        return this;
    }

    @Override
    public HttpPostMultipartBuilder addHeader(String key, String value) {
        super.addHeader(key, value);
        return this;
    }

    @Override
    public HttpPostMultipartBuilder setConnectTimeout(long timeout, TimeUnit unit) {
        super.setConnectTimeout(timeout, unit);
        return this;
    }

    @Override
    public HttpPostMultipartBuilder setReadTimeout(long timeout, TimeUnit unit) {
        super.setReadTimeout(timeout, unit);
        return this;
    }

    @Override
    public HttpPostMultipartBuilder addRequestInterceptor(RequestInterceptor requestInterceptor) {
        super.addRequestInterceptor(requestInterceptor);
        return this;
    }

    @Override
    public HttpPostMultipartBuilder addResponseInterceptor(ResponseInterceptor responseInterceptor) {
        super.addResponseInterceptor(responseInterceptor);
        return this;
    }

    @Override
    public HttpPostMultipartBuilder addNetInterceptor(Interceptor interceptor) {
        super.addNetInterceptor(interceptor);
        return this;
    }

    public HttpPostMultipartBuilder send() throws HttpRequestException {
        this.requestBuilder.url(this.url);
        this.requestBuilder.post((RequestBody)this.builder.build());
        super.sendRequest();
        return this;
    }
}

