/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.http.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.lulihu.ObjectKit.MapKit;
import net.lulihu.http.builder.HttpBuilder;
import net.lulihu.http.builder.HttpRequestException;
import net.lulihu.http.builder.RequestInterceptor;
import net.lulihu.http.builder.ResponseInterceptor;
import okhttp3.Interceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpGetBuilder
extends HttpBuilder {
    private static final Logger log = LoggerFactory.getLogger(HttpGetBuilder.class);
    private Map<String, String> params;

    HttpGetBuilder(String url) {
        super(url);
    }

    @Override
    public HttpGetBuilder setHeader(Map<String, String> header) {
        super.setHeader(header);
        return this;
    }

    @Override
    public HttpGetBuilder addHeader(String key, String value) {
        super.addHeader(key, value);
        return this;
    }

    @Override
    public HttpGetBuilder setConnectTimeout(long timeout, TimeUnit unit) {
        super.setConnectTimeout(timeout, unit);
        return this;
    }

    @Override
    public HttpGetBuilder setReadTimeout(long timeout, TimeUnit unit) {
        super.setReadTimeout(timeout, unit);
        return this;
    }

    @Override
    public HttpGetBuilder addRequestInterceptor(RequestInterceptor requestInterceptor) {
        super.addRequestInterceptor(requestInterceptor);
        return this;
    }

    @Override
    public HttpGetBuilder addResponseInterceptor(ResponseInterceptor responseInterceptor) {
        super.addResponseInterceptor(responseInterceptor);
        return this;
    }

    @Override
    public HttpGetBuilder addNetInterceptor(Interceptor interceptor) {
        super.addNetInterceptor(interceptor);
        return this;
    }

    public HttpGetBuilder setParam(Map<String, String> getParam) {
        this.params = getParam;
        return this;
    }

    public HttpGetBuilder addParam(String key, String value) {
        if (this.params == null) {
            this.params = new HashMap<String, String>();
        }
        this.params.put(key, value);
        return this;
    }

    public HttpGetBuilder send() throws HttpRequestException {
        String urlAndParam = null;
        if (MapKit.isNotEmpty(this.params)) {
            StringBuilder builder = new StringBuilder();
            for (String key : this.params.keySet()) {
                builder.append(key).append("=").append(this.params.get(key)).append("&");
            }
            urlAndParam = this.url + "?" + builder.toString().substring(0, builder.length() - 1);
        }
        this.requestBuilder.get().url(urlAndParam == null ? this.url : urlAndParam);
        super.sendRequest();
        return this;
    }
}

