/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.http.builder;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.lulihu.ObjectKit.FileKit;
import net.lulihu.ObjectKit.MapKit;
import net.lulihu.http.builder.HttpGetBuilder;
import net.lulihu.http.builder.HttpPostBuilder;
import net.lulihu.http.builder.HttpPostMultipartBuilder;
import net.lulihu.http.builder.HttpPostPayloadBuilder;
import net.lulihu.http.builder.HttpRequestException;
import net.lulihu.http.builder.RequestInterceptor;
import net.lulihu.http.builder.RequestLogInterceptor;
import net.lulihu.http.builder.ResponseInterceptor;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpBuilder {
    private static final Logger log = LoggerFactory.getLogger(HttpBuilder.class);
    protected final String url;
    protected Headers.Builder headerBuilder;
    protected OkHttpClient.Builder httpClientBuilder;
    protected Request.Builder requestBuilder;
    protected ResponseBody responseBody;

    public HttpBuilder(String url) {
        this.url = url;
        this.headerBuilder = new Headers.Builder();
        this.httpClientBuilder = new OkHttpClient.Builder();
        this.requestBuilder = new Request.Builder();
        if (log.isDebugEnabled()) {
            this.httpClientBuilder.addInterceptor((Interceptor)new RequestLogInterceptor());
        }
    }

    public static HttpGetBuilder get(String url) {
        return new HttpGetBuilder(url);
    }

    public static HttpPostBuilder post(String url) {
        return new HttpPostBuilder(url);
    }

    public static HttpPostPayloadBuilder postPayload(String url) {
        return new HttpPostPayloadBuilder(url);
    }

    public static HttpPostMultipartBuilder postMultipart(String url) {
        return new HttpPostMultipartBuilder(url);
    }

    public HttpBuilder addNetInterceptor(Interceptor interceptor) {
        this.httpClientBuilder.addNetworkInterceptor(interceptor);
        return this;
    }

    public HttpBuilder addRequestInterceptor(RequestInterceptor requestInterceptor) {
        this.httpClientBuilder.addInterceptor((Interceptor)requestInterceptor);
        return this;
    }

    public HttpBuilder addResponseInterceptor(ResponseInterceptor responseInterceptor) {
        this.httpClientBuilder.addInterceptor((Interceptor)responseInterceptor);
        return this;
    }

    public HttpBuilder setHeader(Map<String, String> header) {
        if (MapKit.isEmpty(header)) {
            throw new NullPointerException("\u8bbe\u7f6e\u7684\u8bf7\u6c42\u5934\u90e8\u4fe1\u606f\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        for (Map.Entry<String, String> entry : header.entrySet()) {
            this.headerBuilder.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public HttpBuilder addHeader(String key, String value) {
        this.headerBuilder.add(key, value);
        return this;
    }

    public HttpBuilder setConnectTimeout(long timeout, TimeUnit unit) {
        this.httpClientBuilder.connectTimeout(timeout, unit);
        return this;
    }

    public HttpBuilder setReadTimeout(long timeout, TimeUnit unit) {
        this.httpClientBuilder.readTimeout(timeout, unit);
        return this;
    }

    protected final void sendRequest() throws HttpRequestException {
        this.requestBuilder.headers(this.headerBuilder.build());
        Request request = this.requestBuilder.build();
        OkHttpClient httpClient = this.httpClientBuilder.build();
        try {
            Response response = httpClient.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw new HttpRequestException(response.code(), response.message(), response.body() == null ? "" : response.body().string());
            }
            this.responseBody = response.body();
        }
        catch (IOException e) {
            throw new HttpRequestException(e, "\u8bf7\u6c42 [{}] \u53d1\u751f\u4f8b\u5916", request.url().toString());
        }
    }

    public void close() {
        this.responseBody.close();
    }

    public InputStream byteStream() {
        try {
            InputStream inputStream = this.responseBody.byteStream();
            return inputStream;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(File file) throws IOException {
        try (BufferedSource source = this.responseBody.source();
             BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)FileKit.createFile(file)));){
            sink.writeAll((Source)source);
            sink.flush();
        }
        finally {
            this.close();
        }
    }

    public String getResult() throws IOException {
        try {
            String string = this.responseBody.string();
            return string;
        }
        finally {
            this.close();
        }
    }

    public <T> T getJsonObjResult(Class<T> resultClass) throws IOException {
        String result = this.getResult();
        if (result == null) {
            return null;
        }
        return (T)JSON.parseObject((String)result, resultClass);
    }

    public <T> List<T> getJsonArrayResult(Class<T> resultClass) throws IOException {
        String result = this.getResult();
        if (result == null) {
            return null;
        }
        return JSON.parseArray((String)result, resultClass);
    }
}

