/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.http;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import net.lulihu.ObjectKit.WafKit;

public class WafRequestWrapper
extends HttpServletRequestWrapper {
    private final boolean filterXSS;
    private final boolean filterSQL;

    public WafRequestWrapper(HttpServletRequest request, boolean filterXSS, boolean filterSQL) {
        super(request);
        this.filterXSS = filterXSS;
        this.filterSQL = filterSQL;
    }

    public WafRequestWrapper(HttpServletRequest request) {
        this(request, true, true);
    }

    public String[] getParameterValues(String parameter) {
        String[] values = super.getParameterValues(parameter);
        if (values == null) {
            return null;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        for (int i = 0; i < count; ++i) {
            encodedValues[i] = this.filterParamString(values[i]);
        }
        return encodedValues;
    }

    public Map getParameterMap() {
        Map primary = super.getParameterMap();
        HashMap result = new HashMap(primary.size());
        for (Map.Entry entry : primary.entrySet()) {
            result.put(entry.getKey(), this.filterEntryString((String[])entry.getValue()));
        }
        return result;
    }

    private String[] filterEntryString(String[] rawValue) {
        for (int i = 0; i < rawValue.length; ++i) {
            rawValue[i] = this.filterParamString(rawValue[i]);
        }
        return rawValue;
    }

    public String getParameter(String parameter) {
        return this.filterParamString(super.getParameter(parameter));
    }

    public String getHeader(String name) {
        return this.filterParamString(super.getHeader(name));
    }

    public Cookie[] getCookies() {
        Cookie[] existingCookies = super.getCookies();
        if (existingCookies != null) {
            for (Cookie cookie : existingCookies) {
                cookie.setValue(this.filterParamString(cookie.getValue()));
            }
        }
        return existingCookies;
    }

    private String filterParamString(String rawValue) {
        if (null == rawValue) {
            return null;
        }
        String tmpStr = rawValue;
        if (this.filterXSS) {
            tmpStr = WafKit.stripXSS(rawValue);
        }
        if (this.filterSQL) {
            tmpStr = WafKit.stripSqlInjection(tmpStr);
        }
        return tmpStr;
    }
}

