/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.formula;

import net.lulihu.formula.ExpressionException;
import net.lulihu.formula.ExpressionNode;
import net.lulihu.formula.ExpressionNodeType;

public class ExpressionParser {
    private String expression;
    private int position;

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public ExpressionParser(String expression) {
        this.expression = expression;
        this.position = 0;
    }

    public ExpressionNode readNode() {
        ExpressionNode s = new ExpressionNode(null);
        int whileSpacePos = -1;
        boolean flag = false;
        StringBuffer buffer = new StringBuffer(10);
        while (this.position < this.expression.length()) {
            char c = this.expression.charAt(this.position);
            if (c == '\"') {
                boolean bl = flag = !flag;
                if (!flag) {
                    ++this.position;
                    buffer.append(c);
                    break;
                }
                if (buffer.length() != 0) break;
            }
            if (flag) {
                ++this.position;
                buffer.append(c);
                continue;
            }
            if (s.IsWhileSpace(c)) {
                if (whileSpacePos >= 0 && this.position - whileSpacePos > 1) {
                    throw new ExpressionException(String.format("\u8868\u8fbe\u5f0f\"%s\"\u5728\u4f4d\u7f6e(%s)\u4e0a\u7684\u5b57\u7b26\u975e\u6cd5!", this.getExpression(), this.getPosition()));
                }
                whileSpacePos = buffer.length() == 0 ? -1 : this.position;
                ++this.position;
                continue;
            }
            if (buffer.length() != 0 && !s.IsCongener(c, buffer.charAt(buffer.length() - 1))) break;
            ++this.position;
            buffer.append(c);
            if (s.needMoreOperator(c)) continue;
            break;
        }
        if (buffer.length() == 0) {
            return null;
        }
        ExpressionNode node = new ExpressionNode(buffer.toString());
        if (node.getType() == ExpressionNodeType.Unknown) {
            throw new ExpressionException(String.format("\u8868\u8fbe\u5f0f\"%s\"\u5728\u4f4d\u7f6e%s\u4e0a\u7684\u5b57\u7b26\"%s\"\u975e\u6cd5!", this.getExpression(), this.getPosition() - node.getValue().length(), node.getValue()));
        }
        return node;
    }
}

