/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.formula;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.lulihu.ObjectKit.StrKit;
import net.lulihu.dateTime.DateTime;
import net.lulihu.dateTime.DateTimeKit;
import net.lulihu.formula.ExpressionException;
import net.lulihu.formula.ExpressionNode;
import net.lulihu.formula.ExpressionNodeType;
import net.lulihu.formula.ExpressionParser;

public class ExpressionEvaluator {
    public static Object eval(String expression) {
        return ExpressionEvaluator.CalcExpression(ExpressionEvaluator.parseExpression(expression));
    }

    public static Object evalThreeOperand(String expression) {
        int index = expression.indexOf("?");
        if (index > -1) {
            String str = expression.substring(0, index);
            String str2 = expression.substring(index + 1);
            index = str2.indexOf(":");
            if (Boolean.parseBoolean(ExpressionEvaluator.CalcExpression(ExpressionEvaluator.parseExpression(str)).toString())) {
                return ExpressionEvaluator.eval(str2.substring(0, index));
            }
            return ExpressionEvaluator.eval(str2.substring(index + 1));
        }
        return ExpressionEvaluator.CalcExpression(ExpressionEvaluator.parseExpression(expression));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<ExpressionNode> parseExpression(String expression) {
        ExpressionNode beforeExpNode;
        ExpressionNode expNode;
        if (StrKit.isEmpty(expression)) {
            return new ArrayList<ExpressionNode>();
        }
        ArrayList<ExpressionNode> listOperator = new ArrayList<ExpressionNode>(10);
        Stack<ExpressionNode> stackOperator = new Stack<ExpressionNode>();
        ExpressionParser expParser = new ExpressionParser(expression);
        ExpressionNode unitaryNode = null;
        boolean requireOperand = false;
        while ((expNode = expParser.readNode()) != null) {
            if (expNode.getType() == ExpressionNodeType.Numeric || expNode.getType() == ExpressionNodeType.String || expNode.getType() == ExpressionNodeType.Date) {
                if (unitaryNode != null) {
                    expNode.setUnitaryNode(unitaryNode);
                    unitaryNode = null;
                }
                listOperator.add(expNode);
                requireOperand = false;
                continue;
            }
            if (expNode.getType() == ExpressionNodeType.LParentheses) {
                stackOperator.push(expNode);
                continue;
            }
            if (expNode.getType() == ExpressionNodeType.RParentheses) {
                ExpressionNode lpNode = null;
                while (stackOperator.size() > 0 && (lpNode = (ExpressionNode)stackOperator.pop()).getType() != ExpressionNodeType.LParentheses) {
                    listOperator.add(lpNode);
                }
                if (lpNode != null && lpNode.getType() == ExpressionNodeType.LParentheses) continue;
                throw new ExpressionException(String.format("\u5728\u8868\u8fbe\u5f0f\"%s\"\u4e2d\u6ca1\u6709\u4e0e\u5728\u4f4d\u7f6e(%s)\u4e0a\")\"\u5339\u914d\u7684\"(%s)\"\u5b57\u7b26!", expParser.getExpression(), expParser.getPosition()));
            }
            if (stackOperator.size() == 0) {
                if (listOperator.size() == 0 && expNode.getType() != ExpressionNodeType.LParentheses && expNode.getType() != ExpressionNodeType.Not) {
                    if (!ExpressionNode.IsUnitaryNode(expNode.getType())) throw new ExpressionException(String.format("\u8868\u8fbe\u5f0f\"%s\"\u5728\u4f4d\u7f6e(%s)\u4e0a\u7f3a\u5c11\u64cd\u4f5c\u6570!", expParser.getExpression(), expParser.getPosition()));
                    unitaryNode = expNode;
                } else {
                    stackOperator.push(expNode);
                }
                requireOperand = true;
                continue;
            }
            if (requireOperand) {
                if (!ExpressionNode.IsUnitaryNode(expNode.getType()) || unitaryNode != null) throw new ExpressionException(String.format("\u8868\u8fbe\u5f0f\"%s\"\u5728\u4f4d\u7f6e({1})\u4e0a\u7f3a\u5c11\u64cd\u4f5c\u6570!", expParser.getExpression(), expParser.getPosition()));
                unitaryNode = expNode;
                continue;
            }
            while ((beforeExpNode = (ExpressionNode)stackOperator.peek()).getType() != ExpressionNodeType.LParentheses && beforeExpNode.getPri() - expNode.getPri() >= 0) {
                listOperator.add((ExpressionNode)stackOperator.pop());
                if (stackOperator.size() > 0) continue;
            }
            stackOperator.push(expNode);
            requireOperand = true;
        }
        if (requireOperand) {
            throw new ExpressionException(String.format("\u8868\u8fbe\u5f0f\"%s\"\u5728\u4f4d\u7f6e({1})\u4e0a\u7f3a\u5c11\u64cd\u4f5c\u6570!", expParser.getExpression(), expParser.getPosition()));
        }
        while (stackOperator.size() > 0) {
            beforeExpNode = (ExpressionNode)stackOperator.pop();
            if (beforeExpNode.getType() == ExpressionNodeType.LParentheses) {
                throw new ExpressionException(String.format("\u8868\u8fbe\u5f0f\"%s\"\u4e2d\u62ec\u53f7\u4e0d\u5339\u914d,\u4e22\u5931\u53f3\u62ec\u53f7!", expParser.getExpression(), expParser.getPosition()));
            }
            listOperator.add(beforeExpNode);
        }
        return listOperator;
    }

    private static Object CalcExpression(List<ExpressionNode> nodes) {
        if (nodes == null || nodes.size() == 0) {
            return null;
        }
        if (nodes.size() > 1) {
            int index = 0;
            ArrayList<Object> values = new ArrayList<Object>();
            block7: while (index < nodes.size()) {
                int i;
                ExpressionNode node = nodes.get(index);
                switch (node.getType()) {
                    case Numeric: 
                    case String: 
                    case Date: {
                        values.add(node.getNumeric());
                        ++index;
                        continue block7;
                    }
                }
                int paramCount = 2;
                if (node.getType() == ExpressionNodeType.Not) {
                    paramCount = 1;
                }
                if (values.size() < paramCount) {
                    throw new ExpressionException("\u7f3a\u5c11\u64cd\u4f5c\u6570");
                }
                Object[] data = new Object[paramCount];
                for (i = 0; i < paramCount; ++i) {
                    data[i] = values.get(index - paramCount + i);
                }
                node.setNumeric(ExpressionEvaluator.calculate(node.getType(), data));
                node.setType(ExpressionNodeType.Numeric);
                for (i = 0; i < paramCount; ++i) {
                    nodes.remove(index - i - 1);
                    values.remove(index - i - 1);
                }
                index -= paramCount;
            }
        }
        if (nodes.size() != 1) {
            throw new ExpressionException("\u7f3a\u5c11\u64cd\u4f5c\u7b26\u6216\u64cd\u4f5c\u6570");
        }
        switch (nodes.get(0).getType()) {
            case Numeric: {
                return nodes.get(0).getNumeric();
            }
            case String: 
            case Date: {
                return nodes.get(0).getNumeric().toString().replace("\"", "");
            }
        }
        throw new ExpressionException("\u7f3a\u5c11\u64cd\u4f5c\u6570");
    }

    private static Object calculate(ExpressionNodeType nodeType, Object[] data) {
        Object obj1 = data[0];
        Object obj2 = data[1];
        String str1 = obj1.toString();
        String str2 = obj2.toString();
        boolean dateflag = ExpressionNode.isDatetime(str1) || ExpressionNode.isDatetime(str2);
        boolean strflag = str1.contains("\"") || str2.contains("\"");
        str1 = str1.replace("\"", "");
        str2 = str2.replace("\"", "");
        switch (nodeType) {
            case Plus: {
                if (!strflag) {
                    double d1 = ExpressionEvaluator.ConvertToDecimal(obj1);
                    double d2 = ExpressionEvaluator.ConvertToDecimal(obj2);
                    return d1 + d2;
                }
                return new StringBuffer(str1 + str2).toString();
            }
            case Subtract: {
                double d1 = ExpressionEvaluator.ConvertToDecimal(obj1);
                double d2 = ExpressionEvaluator.ConvertToDecimal(obj2);
                return d1 - d2;
            }
            case MultiPly: {
                double d1 = ExpressionEvaluator.ConvertToDecimal(obj1);
                double d2 = ExpressionEvaluator.ConvertToDecimal(obj2);
                return d1 * d2;
            }
            case Divide: {
                double d1 = ExpressionEvaluator.ConvertToDecimal(obj1);
                double d2 = ExpressionEvaluator.ConvertToDecimal(obj2);
                if (d2 == 0.0) {
                    throw new RuntimeException();
                }
                return d1 / d2;
            }
            case Power: {
                double d1 = ExpressionEvaluator.ConvertToDecimal(obj1);
                double d2 = ExpressionEvaluator.ConvertToDecimal(obj2);
                return Math.pow(d1, d2);
            }
            case Mod: {
                double d1 = ExpressionEvaluator.ConvertToDecimal(obj1);
                double d2 = ExpressionEvaluator.ConvertToDecimal(obj2);
                if (d2 == 0.0) {
                    throw new RuntimeException();
                }
                return d1 % d2;
            }
            case BitwiseAnd: {
                double d1 = ExpressionEvaluator.ConvertToDecimal(obj1);
                double d2 = ExpressionEvaluator.ConvertToDecimal(obj2);
                return (int)d1 & (int)d2;
            }
            case BitwiseOr: {
                double d1 = ExpressionEvaluator.ConvertToDecimal(obj1);
                double d2 = ExpressionEvaluator.ConvertToDecimal(obj2);
                return (int)d1 | (int)d2;
            }
            case And: {
                boolean b1 = ExpressionEvaluator.ConvertToBool(obj1);
                boolean b2 = ExpressionEvaluator.ConvertToBool(obj2);
                return b1 && b2;
            }
            case Or: {
                boolean b1 = ExpressionEvaluator.ConvertToBool(obj1);
                boolean b2 = ExpressionEvaluator.ConvertToBool(obj2);
                return b1 || b2;
            }
            case Not: {
                boolean b1 = ExpressionEvaluator.ConvertToBool(obj1);
                return !b1;
            }
            case Equal: {
                if (!dateflag) {
                    double d2;
                    if (strflag) {
                        return str1.equals(str2);
                    }
                    double d1 = ExpressionEvaluator.ConvertToDecimal(obj1);
                    return d1 == (d2 = ExpressionEvaluator.ConvertToDecimal(obj2).doubleValue());
                }
                DateTime time1 = DateTimeKit.parseDate(str1);
                DateTime time2 = DateTimeKit.parseDate(str2);
                return time1.getTime() == time2.getTime();
            }
            case Unequal: {
                if (!dateflag) {
                    double d2;
                    if (strflag) {
                        return !str1.equals(str2);
                    }
                    double d1 = ExpressionEvaluator.ConvertToDecimal(obj1);
                    return d1 != (d2 = ExpressionEvaluator.ConvertToDecimal(obj2).doubleValue());
                }
                DateTime time1 = DateTimeKit.parseDate(str1);
                DateTime time2 = DateTimeKit.parseDate(str2);
                return time1.getTime() != time2.getTime();
            }
            case GT: {
                if (!dateflag) {
                    double d2;
                    double d1 = ExpressionEvaluator.ConvertToDecimal(obj1);
                    return d1 > (d2 = ExpressionEvaluator.ConvertToDecimal(obj2).doubleValue());
                }
                DateTime time1 = DateTimeKit.parseDate(str1);
                DateTime time2 = DateTimeKit.parseDate(str2);
                return time1.getTime() > time2.getTime();
            }
            case LT: {
                if (!dateflag) {
                    double d2;
                    double d1 = ExpressionEvaluator.ConvertToDecimal(obj1);
                    return d1 < (d2 = ExpressionEvaluator.ConvertToDecimal(obj2).doubleValue());
                }
                DateTime time1 = DateTimeKit.parseDate(str1);
                DateTime time2 = DateTimeKit.parseDate(str2);
                return time1.getTime() < time2.getTime();
            }
            case GTOrEqual: {
                if (!dateflag) {
                    double d2;
                    double d1 = ExpressionEvaluator.ConvertToDecimal(obj1);
                    return d1 >= (d2 = ExpressionEvaluator.ConvertToDecimal(obj2).doubleValue());
                }
                DateTime time1 = DateTimeKit.parseDate(str1);
                DateTime time2 = DateTimeKit.parseDate(str2);
                return time1.getTime() >= time2.getTime();
            }
            case LTOrEqual: {
                if (!dateflag) {
                    double d2;
                    double d1 = ExpressionEvaluator.ConvertToDecimal(obj1);
                    return d1 <= (d2 = ExpressionEvaluator.ConvertToDecimal(obj2).doubleValue());
                }
                DateTime time1 = DateTimeKit.parseDate(str1);
                DateTime time2 = DateTimeKit.parseDate(str2);
                return time1.getTime() <= time2.getTime();
            }
            case LShift: {
                double d1 = ExpressionEvaluator.ConvertToDecimal(obj1);
                double d2 = ExpressionEvaluator.ConvertToDecimal(obj2);
                return (long)d1 << (int)d2;
            }
            case RShift: {
                double d1 = ExpressionEvaluator.ConvertToDecimal(obj1);
                double d2 = ExpressionEvaluator.ConvertToDecimal(obj2);
                return (long)d1 >> (int)d2;
            }
            case Like: {
                if (!strflag) {
                    return false;
                }
                return str1.contains(str2);
            }
            case NotLike: {
                if (!strflag) {
                    return false;
                }
                return !str1.contains(str2);
            }
            case StartWith: {
                if (!strflag) {
                    return false;
                }
                return str1.startsWith(str2);
            }
            case EndWith: {
                if (!strflag) {
                    return false;
                }
                return str1.endsWith(str2);
            }
        }
        return 0;
    }

    private static Boolean ConvertToBool(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return value != null;
    }

    private static Double ConvertToDecimal(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        return Double.parseDouble(value.toString());
    }
}

