/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.disruptorKit.demo;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.WorkHandler;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import net.lulihu.ObjectKit.StrKit;
import net.lulihu.designPattern.chain.AbstractHandlerResponsibilityChainResolver;
import net.lulihu.designPattern.chain.ChainEventException;
import net.lulihu.designPattern.chain.ResponsibilityChainHandler;
import net.lulihu.disruptorKit.DefaultEventFactory;
import net.lulihu.disruptorKit.DisruptorManage;
import net.lulihu.disruptorKit.Producer;
import net.lulihu.disruptorKit.oneOf.WorkHandlerManage;

public class WorkHandlerDemo {
    public static void main(String[] args) {
        ResponsibilityChainHandler<Integer> intHandler = new ResponsibilityChainHandler<Integer>();
        intHandler.addHandler(new IntegerHandler(1)).addHandler(new IntegerHandler(2));
        ResponsibilityChainHandler<String> strHandler = new ResponsibilityChainHandler<String>();
        strHandler.addHandler(new StringHandler(1)).addHandler(new StringHandler(2));
        WorkHandlerManage handlerManage = WorkHandlerManage.getInstance();
        handlerManage.addWorkHandler(Integer.class, intHandler);
        handlerManage.addWorkHandler(String.class, strHandler);
        DisruptorManage instance = DisruptorManage.getInstance();
        EventFactory eventFactory = DefaultEventFactory.factory();
        String name = "workHandlerTest";
        Disruptor eventDisruptor = instance.registered(name, eventFactory, 16, ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
        Producer<Object> producer = new Producer<Object>(eventDisruptor.getRingBuffer());
        eventDisruptor.handleEventsWithWorkerPool((WorkHandler[])handlerManage.consumerNum(1));
        eventDisruptor.start();
        for (int i = 0; i < 5; ++i) {
            if (i % 2 == 0) {
                producer.submit(i);
                continue;
            }
            producer.submit("o");
        }
        instance.shutdown(name);
    }

    public static class StringHandler
    extends AbstractHandlerResponsibilityChainResolver<String> {
        private int number;

        public StringHandler(int number) {
            super("\u5b57\u7b26\u7c7b\u578b\u5904\u7406\u8005");
            this.number = number;
        }

        @Override
        public void resolve(String data) throws ChainEventException {
            System.out.println(StrKit.format("\u5b57\u7b26\u7c7b\u578b\u5904\u7406\u8005-{}, \u5904\u7406\u53c2\u6570:{}", this.number, data));
        }

        @Override
        public String result(String data) {
            data = data + "i";
            return data;
        }
    }

    public static class IntegerHandler
    extends AbstractHandlerResponsibilityChainResolver<Integer> {
        private int number;

        public IntegerHandler(int number) {
            super("\u6574\u6570\u7c7b\u578b\u5904\u7406\u8005");
            this.number = number;
        }

        @Override
        public void resolve(Integer data) throws ChainEventException {
            System.out.println(StrKit.format("\u6574\u6570\u7c7b\u578b\u5904\u7406\u8005-{}, \u5904\u7406\u53c2\u6570:{}", this.number, data));
        }

        @Override
        public Integer result(Integer data) {
            data = data + 1;
            return data;
        }
    }
}

