/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.disruptorKit.demo;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.WorkHandler;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import net.lulihu.disruptorKit.Consumer;
import net.lulihu.disruptorKit.DefaultEventFactory;
import net.lulihu.disruptorKit.DisruptorManage;
import net.lulihu.disruptorKit.Event;
import net.lulihu.disruptorKit.Producer;

public class HelloWorld {
    public static void main(String[] args) {
        DisruptorManage instance = DisruptorManage.getInstance();
        EventFactory eventFactory = DefaultEventFactory.factory();
        Disruptor eventDisruptor = instance.registered("test", eventFactory, 16, ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
        Producer<TestEvent> producer = new Producer<TestEvent>(eventDisruptor.getRingBuffer());
        eventDisruptor.handleEventsWithWorkerPool(new WorkHandler[]{new Consumer1(), new Consumer3()}).handleEventsWithWorkerPool(new WorkHandler[]{new Consumer2()});
        eventDisruptor.start();
        for (int i = 0; i < 2; ++i) {
            TestEvent testEvent = new TestEvent(i);
            producer.submit(testEvent);
        }
    }

    public static class Consumer3
    extends Consumer<TestEvent> {
        public Consumer3() {
            super("\u6d88\u8d39\u80053");
        }

        @Override
        public void consumption(Event<TestEvent> event) throws Exception {
            System.out.println(event.getElement().toString());
        }
    }

    public static class Consumer2
    extends Consumer<TestEvent> {
        public Consumer2() {
            super("\u6d88\u8d39\u80052");
        }

        @Override
        public void consumption(Event<TestEvent> event) throws Exception {
            System.out.println(event.getElement().toString());
        }
    }

    public static class Consumer1
    extends Consumer<TestEvent> {
        public Consumer1() {
            super("\u6d88\u8d39\u80051");
        }

        @Override
        public void consumption(Event<TestEvent> event) throws Exception {
            System.out.println(event.getElement().toString());
        }
    }

    public static class TestEvent {
        private Integer i;

        public Integer getI() {
            return this.i;
        }

        public void setI(Integer i) {
            this.i = i;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TestEvent)) {
                return false;
            }
            TestEvent other = (TestEvent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$i = this.getI();
            Integer other$i = other.getI();
            return !(this$i == null ? other$i != null : !((Object)this$i).equals(other$i));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TestEvent;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $i = this.getI();
            result = result * 59 + ($i == null ? 43 : ((Object)$i).hashCode());
            return result;
        }

        public TestEvent(Integer i) {
            this.i = i;
        }

        public String toString() {
            return "HelloWorld.TestEvent(i=" + this.getI() + ")";
        }
    }
}

