/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.disruptorKit;

import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.WorkHandler;
import net.lulihu.disruptorKit.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Consumer<T>
implements EventHandler<Event<T>>,
WorkHandler<Event<T>> {
    private static final Logger log = LoggerFactory.getLogger(Consumer.class);
    private final String name;

    public Consumer(String name) {
        this.name = name;
    }

    public final void onEvent(Event<T> event) throws Exception {
        this.run(event);
    }

    public final void onEvent(Event<T> event, long sequence, boolean endOfBatch) throws Exception {
        this.run(event);
    }

    private void run(Event<T> event) {
        if (!this.runBefore(event)) {
            return;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("- {} \u5f00\u59cb\u5904\u7406\u4e8b\u4ef6...", (Object)this.name);
            }
            this.consumption(event);
            if (log.isDebugEnabled()) {
                log.debug("- {} \u4e8b\u4ef6\u5904\u7406\u7ed3\u675f...", (Object)this.name);
            }
            this.runSuccess(event);
        }
        catch (Throwable e) {
            log.error("- {} \u5904\u7406\u4e8b\u4ef6\u53d1\u751f\u9519\u8bef,\u9519\u8bef\u4fe1\u606f\u4e3a:", (Object)this.name, (Object)e);
            this.runError(event, e);
        }
        finally {
            this.runFinally(event);
        }
    }

    private boolean runBefore(Event<T> event) {
        boolean boo;
        try {
            if (log.isDebugEnabled()) {
                log.debug("- {} \u5f00\u59cb\u5904\u7406\u4e8b\u4ef6Before\u5757...", (Object)this.name);
            }
            boo = this.consumptionBefore(event);
            if (log.isDebugEnabled()) {
                log.debug("- {} \u4e8b\u4ef6Before\u5757\u5904\u7406\u7ed3\u675f...", (Object)this.name);
            }
        }
        catch (Exception e) {
            log.error("- {} \u5904\u7406\u4e8b\u4ef6Before\u5757\u53d1\u751f\u9519\u8bef,\u9519\u8bef\u4fe1\u606f\u4e3a:", (Object)this.name, (Object)e);
            boo = false;
        }
        return boo;
    }

    private void runSuccess(Event<T> event) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("- {} \u5f00\u59cb\u5904\u7406\u4e8b\u4ef6Success\u5757...", (Object)this.name);
            }
            this.consumptionSuccess(event);
            if (log.isDebugEnabled()) {
                log.debug("- {} \u4e8b\u4ef6Success\u5757\u5904\u7406\u7ed3\u675f...", (Object)this.name);
            }
        }
        catch (Exception e) {
            log.error("- {} \u5904\u7406\u4e8b\u4ef6Success\u5757\u53d1\u751f\u9519\u8bef,\u9519\u8bef\u4fe1\u606f\u4e3a:", (Object)this.name, (Object)e);
        }
    }

    private void runError(Event<T> event, Throwable throwable) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("- {} \u5f00\u59cb\u5904\u7406\u4e8b\u4ef6Error\u5757...", (Object)this.name);
            }
            this.consumptionError(event, throwable);
            if (log.isDebugEnabled()) {
                log.debug("- {} \u4e8b\u4ef6Error\u5757\u5904\u7406\u7ed3\u675f...", (Object)this.name);
            }
        }
        catch (Exception e) {
            log.error("- {} \u5904\u7406\u4e8b\u4ef6Error\u5757\u53d1\u751f\u9519\u8bef,\u9519\u8bef\u4fe1\u606f\u4e3a:", (Object)this.name, (Object)e);
        }
    }

    private void runFinally(Event<T> event) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("- {} \u5f00\u59cb\u5904\u7406\u4e8b\u4ef6Finally\u5757...", (Object)this.name);
            }
            this.consumptionFinally(event);
            if (log.isDebugEnabled()) {
                log.debug("- {} \u4e8b\u4ef6Finally\u5757\u5904\u7406\u7ed3\u675f...", (Object)this.name);
            }
        }
        catch (Throwable e) {
            log.error("- {} \u5904\u7406\u4e8b\u4ef6Finally\u5757\u53d1\u751f\u9519\u8bef,\u9519\u8bef\u4fe1\u606f\u4e3a:", (Object)this.name, (Object)e);
        }
    }

    public abstract void consumption(Event<T> var1) throws Exception;

    public boolean consumptionBefore(Event<T> event) throws Exception {
        return true;
    }

    public void consumptionSuccess(Event<T> event) throws Exception {
    }

    public void consumptionError(Event<T> event, Throwable e) throws Exception {
    }

    public void consumptionFinally(Event<T> event) throws Exception {
    }
}

