/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.lulihu.ObjectKit.EncryptionKit;
import net.lulihu.ObjectKit.FileKit;
import net.lulihu.ObjectKit.HexKit;
import net.lulihu.ObjectKit.IDGeneratorKit;
import net.lulihu.ObjectKit.MapKit;
import net.lulihu.ObjectKit.NativeKit;
import net.lulihu.ObjectKit.ObjectKit;
import net.lulihu.ObjectKit.StrKit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolKit {
    private static final Logger log = LoggerFactory.getLogger(ToolKit.class);
    private static final String[] baseStrings = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private static final int baseLen = baseStrings.length;

    public static String getToken(String jamStr) {
        byte[] bytes = StrKit.bytes(jamStr + IDGeneratorKit.getStr(), Charset.defaultCharset());
        return EncryptionKit.base64Encode(bytes);
    }

    public static String getRandomHexString(int len) {
        return HexKit.getRandomHexString(len);
    }

    public static String getRandomString(int length) {
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(baseLen);
            sb.append(baseStrings[number]);
        }
        return sb.toString();
    }

    public static String getExceptionMsg(Throwable e) {
        StringWriter sw = new StringWriter();
        try {
            e.printStackTrace(new PrintWriter(sw));
        }
        finally {
            try {
                sw.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return sw.getBuffer().toString().replaceAll("\\$", "T");
    }

    public static boolean equals(Object obj1, Object obj2) {
        return ObjectKit.equals(obj1, obj2);
    }

    public static int length(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).size();
        }
        if (obj instanceof Map) {
            return ((Map)obj).size();
        }
        if (obj instanceof Iterator) {
            Iterator iter = (Iterator)obj;
            int count = 0;
            while (iter.hasNext()) {
                ++count;
                iter.next();
            }
            return count;
        }
        if (obj instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)obj;
            int count = 0;
            while (enumeration.hasMoreElements()) {
                ++count;
                enumeration.nextElement();
            }
            return count;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj);
        }
        return -1;
    }

    public static boolean contains(Object obj, Object element) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof String) {
            return element != null && ((String)obj).contains(element.toString());
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).contains(element);
        }
        if (obj instanceof Map) {
            return ((Map)obj).values().contains(element);
        }
        if (obj instanceof Iterator) {
            Iterator iter = (Iterator)obj;
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!ToolKit.equals(o, element)) continue;
                return true;
            }
            return false;
        }
        if (obj instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)obj;
            while (enumeration.hasMoreElements()) {
                Object o = enumeration.nextElement();
                if (!ToolKit.equals(o, element)) continue;
                return true;
            }
            return false;
        }
        if (obj.getClass().isArray()) {
            int len = Array.getLength(obj);
            for (int i = 0; i < len; ++i) {
                Object o = Array.get(obj, i);
                if (!ToolKit.equals(o, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNum(Object obj) {
        try {
            Integer.parseInt(obj.toString());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String format(String template, Object ... values) {
        return StrKit.format(template, values);
    }

    public static String format(String template, Map<?, ?> map) {
        return StrKit.format(template, map);
    }

    public static Map<String, Object> caseInsensitiveMap(Map<String, Object> map) {
        return MapKit.caseInsensitiveMap(map);
    }

    public static <K, V> V getFirstOrNull(Map<K, V> map) {
        return MapKit.getFirstOrNull(map);
    }

    public static StringBuilder builder(String ... strs) {
        return StrKit.builder(strs);
    }

    public static String removeSuffix(String str, String suffix) {
        return StrKit.removeSuffix(str, suffix);
    }

    public static String firstLetterToUpper(String val) {
        return StrKit.firstCharToUpperCase(val);
    }

    public static String firstLetterToLower(String val) {
        return StrKit.firstCharToLowerCase(val);
    }

    public static Boolean isWinOs() {
        return NativeKit.isWinOs();
    }

    public static String getTempPath() {
        return FileKit.getTempPath();
    }

    public static String getWebRootPath(String filePath) throws URISyntaxException {
        String path = Objects.requireNonNull(ToolKit.class.getClassLoader().getResource("")).toURI().getPath();
        path = path.replace("/WEB-INF/classes/", "");
        path = path.replace("/target/classes/", "");
        path = path.replace("file:/", "");
        if (StrKit.isEmpty(filePath)) {
            return path;
        }
        return path + "/" + filePath;
    }

    public static String getFileSuffix(String fileWholeName) {
        if (StrKit.isEmpty(fileWholeName)) {
            return null;
        }
        int lastIndexOf = fileWholeName.lastIndexOf(".");
        return fileWholeName.substring(lastIndexOf + 1);
    }
}

