/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.ObjectKit;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.lulihu.ObjectKit.CollectionKit;
import net.lulihu.functional.ConsumerResult;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrKit {
    private static final Logger log = LoggerFactory.getLogger(StrKit.class);
    public static final String SPACE = " ";
    public static final String DOT = ".";
    public static final String SLASH = "/";
    public static final String BACKSLASH = "\\";
    public static final String EMPTY = "";
    public static final String CRLF = "\r|\n";
    public static final String NEWLINE = "\n";
    public static final String UNDERLINE = "_";
    public static final String COMMA = ",";
    public static final String HTML_NBSP = "&nbsp;";
    public static final String HTML_AMP = "&amp";
    public static final String HTML_QUOTE = "&quot;";
    public static final String HTML_LT = "&lt;";
    public static final String HTML_GT = "&gt;";
    public static final String EMPTY_JSON = "{}";

    private StrKit() {
    }

    public static <E> String listStitchingStr(Collection<E> list, ConsumerResult<E, String> consumer) {
        return StrKit.listStitchingStr(list, COMMA, consumer);
    }

    @SafeVarargs
    public static <E> String listStitchingStr(ConsumerResult<E, String> consumer, E ... list) {
        if (CollectionKit.isEmpty(list)) {
            return EMPTY;
        }
        return StrKit.listStitchingStr(Arrays.asList(list), COMMA, consumer);
    }

    @SafeVarargs
    public static <E> String stitchingStr(String sep, E ... list) {
        return StrKit.listStitchingStr(Arrays.asList(list), sep, null);
    }

    public static <E> String listStitchingStr(Iterable<E> list, String sep, ConsumerResult<E, String> consumer) {
        if (null == list) {
            return EMPTY;
        }
        StringBuilder builder = new StringBuilder();
        for (E item : list) {
            builder.append((Object)(Objects.nonNull(consumer) ? consumer.accept(item) : item)).append(sep);
        }
        int length = builder.length();
        builder.delete(length - sep.length(), length);
        return builder.toString();
    }

    public static String escapeJava(String str) {
        return StringEscapeUtils.escapeJson((String)str);
    }

    public static String unescapeJava(String str) {
        return StringEscapeUtils.unescapeJava((String)str);
    }

    public static String unescapeJson(String str) {
        return StringEscapeUtils.unescapeJson((String)str);
    }

    public static String toSBC(String str) {
        if (StrKit.isEmpty(str)) {
            return EMPTY;
        }
        char[] c = str.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (c[i] >= '\u007f') continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static String firstCharToLowerCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String firstCharToUpperCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return str;
    }

    public static boolean isBlank(String str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean notBlank(String str) {
        return !StrKit.isBlank(str);
    }

    public static boolean hasBlank(String ... strs) {
        if (CollectionKit.isEmpty(strs)) {
            return true;
        }
        for (String str : strs) {
            if (!StrKit.isBlank(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllBlank(String ... strs) {
        if (CollectionKit.isEmpty(strs)) {
            return true;
        }
        for (String str : strs) {
            if (!StrKit.notBlank(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StrKit.isEmpty(str);
    }

    public static String nullToEmpty(String str) {
        return StrKit.nullToDefault(str, EMPTY);
    }

    public static String nullToDefault(String str, String defaultStr) {
        return StrKit.isEmpty(str) ? defaultStr : str;
    }

    public static String emptyToNull(String str) {
        return StrKit.isEmpty(str) ? null : str;
    }

    public static boolean hasEmpty(String ... strs) {
        if (CollectionKit.isEmpty(strs)) {
            return true;
        }
        for (String str : strs) {
            if (!StrKit.isEmpty(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllEmpty(String ... strs) {
        if (CollectionKit.isEmpty(strs)) {
            return true;
        }
        for (String str : strs) {
            if (!StrKit.isNotEmpty(str)) continue;
            return false;
        }
        return true;
    }

    public static String trim(String str) {
        return null == str ? null : StrKit.trim(str, 0);
    }

    public static void trim(String[] strs) {
        if (null == strs) {
            return;
        }
        for (int i = 0; i < strs.length; ++i) {
            String str = strs[i];
            if (null == str) continue;
            strs[i] = str.trim();
        }
    }

    public static String trimStart(String str) {
        return StrKit.trim(str, -1);
    }

    public static String trimEnd(String str) {
        return StrKit.trim(str, 1);
    }

    public static String trim(String str, int mode) {
        int start;
        if (str == null) {
            return null;
        }
        int length = str.length();
        int end = length;
        if (mode <= 0) {
            for (start = 0; start < end && Character.isWhitespace(str.charAt(start)); ++start) {
            }
        }
        if (mode >= 0) {
            while (start < end && Character.isWhitespace(str.charAt(end - 1))) {
                --end;
            }
        }
        if (start > 0 || end < length) {
            return str.substring(start, end);
        }
        return str;
    }

    public static boolean startWith(String str, String prefix, boolean isIgnoreCase) {
        if (isIgnoreCase) {
            return str.toLowerCase().startsWith(prefix.toLowerCase());
        }
        return str.startsWith(prefix);
    }

    public static boolean endWith(String str, String suffix, boolean isIgnoreCase) {
        if (isIgnoreCase) {
            return str.toLowerCase().endsWith(suffix.toLowerCase());
        }
        return str.endsWith(suffix);
    }

    public static boolean containsIgnoreCase(String str, String testStr) {
        if (null == str) {
            return null == testStr;
        }
        return str.toLowerCase().contains(testStr.toLowerCase());
    }

    public static String getGeneralField(String getOrSetMethodName) {
        if (getOrSetMethodName.startsWith("get") || getOrSetMethodName.startsWith("set")) {
            return StrKit.cutPreAndLowerFirst(getOrSetMethodName, 3);
        }
        return null;
    }

    public static String genSetter(String fieldName) {
        return StrKit.upperFirstAndAddPre(fieldName, "set");
    }

    public static String genGetter(String fieldName) {
        return StrKit.upperFirstAndAddPre(fieldName, "get");
    }

    public static String cutPreAndLowerFirst(String str, int preLength) {
        if (str == null) {
            return null;
        }
        if (str.length() > preLength) {
            char first = Character.toLowerCase(str.charAt(preLength));
            if (str.length() > preLength + 1) {
                return first + str.substring(preLength + 1);
            }
            return String.valueOf(first);
        }
        return null;
    }

    public static String upperFirstAndAddPre(String str, String preString) {
        if (str == null || preString == null) {
            return null;
        }
        return preString + StrKit.upperFirst(str);
    }

    public static String upperFirst(String str) {
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static String lowerFirst(String str) {
        if (StrKit.isBlank(str)) {
            return str;
        }
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    public static String removePrefix(String str, String prefix) {
        if (StrKit.isEmpty(str) || StrKit.isEmpty(prefix)) {
            return str;
        }
        if (str.startsWith(prefix)) {
            return str.substring(prefix.length());
        }
        return str;
    }

    public static String removePrefixIgnoreCase(String str, String prefix) {
        if (StrKit.isEmpty(str) || StrKit.isEmpty(prefix)) {
            return str;
        }
        if (str.toLowerCase().startsWith(prefix.toLowerCase())) {
            return str.substring(prefix.length());
        }
        return str;
    }

    public static String removeSuffix(String str, String suffix) {
        if (StrKit.isEmpty(str) || StrKit.isEmpty(suffix)) {
            return str;
        }
        if (str.endsWith(suffix)) {
            return str.substring(0, str.length() - suffix.length());
        }
        return str;
    }

    public static byte[] getBytes(String str, Charset charset) {
        if (null == str) {
            return null;
        }
        return null == charset ? str.getBytes() : str.getBytes(charset);
    }

    public static String removeSuffixIgnoreCase(String str, String suffix) {
        if (StrKit.isEmpty(str) || StrKit.isEmpty(suffix)) {
            return str;
        }
        if (str.toLowerCase().endsWith(suffix.toLowerCase())) {
            return str.substring(0, str.length() - suffix.length());
        }
        return str;
    }

    public static String addPrefixIfNot(String str, String prefix) {
        if (StrKit.isEmpty(str) || StrKit.isEmpty(prefix)) {
            return str;
        }
        if (!str.startsWith(prefix)) {
            str = prefix + str;
        }
        return str;
    }

    public static String addSuffixIfNot(String str, String suffix) {
        if (StrKit.isEmpty(str) || StrKit.isEmpty(suffix)) {
            return str;
        }
        if (!str.endsWith(suffix)) {
            str = str + suffix;
        }
        return str;
    }

    public static String cleanBlank(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("\\s*", EMPTY);
    }

    public static List<String> split(String str, char separator) {
        return StrKit.split(str, separator, 0);
    }

    public static List<String> split(String str, char separator, int limit) {
        if (str == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(limit == 0 ? 16 : limit);
        if (limit == 1) {
            list.add(str);
            return list;
        }
        boolean isNotEnd = true;
        int strLen = str.length();
        StringBuilder sb = new StringBuilder(strLen);
        for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            if (isNotEnd && c == separator) {
                list.add(sb.toString());
                sb.delete(0, sb.length());
                if (limit == 0 || list.size() != limit - 1) continue;
                isNotEnd = false;
                continue;
            }
            sb.append(c);
        }
        list.add(sb.toString());
        return list;
    }

    public static String[] split(String str, String delimiter) {
        int i;
        if (str == null) {
            return null;
        }
        if (str.trim().length() == 0) {
            return new String[]{str};
        }
        int dellen = delimiter.length();
        int maxparts = str.length() / dellen + 2;
        int[] positions = new int[maxparts];
        int j = 0;
        int count = 0;
        positions[0] = -dellen;
        while ((i = str.indexOf(delimiter, j)) != -1) {
            positions[++count] = i;
            j = i + dellen;
        }
        positions[++count] = str.length();
        String[] result = new String[count];
        for (i = 0; i < count; ++i) {
            result[i] = str.substring(positions[i] + dellen, positions[i + 1]);
        }
        return result;
    }

    public static String sub(String string, int fromIndex, int toIndex) {
        int len = string.length();
        if (fromIndex < 0) {
            if ((fromIndex = len + fromIndex) < 0) {
                fromIndex = 0;
            }
        } else if (fromIndex >= len) {
            fromIndex = len - 1;
        }
        if (toIndex < 0) {
            if ((toIndex = len + toIndex) < 0) {
                toIndex = len;
            }
        } else if (toIndex > len) {
            toIndex = len;
        }
        if (toIndex < fromIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        if (fromIndex == toIndex) {
            return EMPTY;
        }
        char[] strArray = string.toCharArray();
        char[] newStrArray = Arrays.copyOfRange(strArray, fromIndex, toIndex);
        return new String(newStrArray);
    }

    public static String subPre(String string, int toIndex) {
        return StrKit.sub(string, 0, toIndex);
    }

    public static String subSuf(String string, int fromIndex) {
        if (StrKit.isEmpty(string)) {
            return null;
        }
        return StrKit.sub(string, fromIndex, string.length());
    }

    public static boolean isSurround(String str, String prefix, String suffix) {
        if (StrKit.isBlank(str)) {
            return false;
        }
        if (str.length() < prefix.length() + suffix.length()) {
            return false;
        }
        return str.startsWith(prefix) && str.endsWith(suffix);
    }

    public static boolean isSurround(String str, char prefix, char suffix) {
        if (StrKit.isBlank(str)) {
            return false;
        }
        if (str.length() < 2) {
            return false;
        }
        return str.charAt(0) == prefix && str.charAt(str.length() - 1) == suffix;
    }

    public static String repeat(char c, int count) {
        char[] result = new char[count];
        for (int i = 0; i < count; ++i) {
            result[i] = c;
        }
        return new String(result);
    }

    public static String repeat(String str, int count) {
        int n;
        int len = str.length();
        int longSize = len * count;
        char[] array = new char[longSize];
        str.getChars(0, len, array, 0);
        for (n = len; n < longSize - n; n <<= 1) {
            System.arraycopy(array, 0, array, n, n);
        }
        System.arraycopy(array, 0, array, n, longSize - n);
        return new String(array);
    }

    public static boolean equals(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equalsIgnoreCase(str2);
    }

    public static String formatOne(String template, Object value) {
        if (value == null || StrKit.isBlank(template)) {
            return template;
        }
        StringBuilder sb = new StringBuilder();
        int length = template.length();
        for (int i = 0; i < length; ++i) {
            char currentChar = template.charAt(i);
            if (currentChar == '{') {
                char nextChar;
                if ((nextChar = template.charAt(++i)) == '}') {
                    sb.append(value);
                    continue;
                }
                sb.append('{').append(nextChar);
                continue;
            }
            sb.append(currentChar);
        }
        return sb.toString();
    }

    public static String format(String template, List<Object> values) {
        if (CollectionKit.isEmpty(values) || StrKit.isBlank(template)) {
            return template;
        }
        StringBuilder sb = new StringBuilder();
        int length = template.length();
        int valen = values.size();
        int valueIndex = 0;
        for (int i = 0; i < length; ++i) {
            if (valueIndex >= valen) {
                sb.append(StrKit.sub(template, i, length));
                break;
            }
            char currentChar = template.charAt(i);
            if (currentChar == '{') {
                char nextChar;
                if ((nextChar = template.charAt(++i)) == '}') {
                    sb.append(values.get(valueIndex++));
                    continue;
                }
                sb.append('{').append(nextChar);
                continue;
            }
            sb.append(currentChar);
        }
        return sb.toString();
    }

    public static String format(String template, Object ... values) {
        if (CollectionKit.isEmpty(values) || StrKit.isBlank(template)) {
            return template;
        }
        StringBuilder sb = new StringBuilder();
        int length = template.length();
        int valen = values.length;
        int valueIndex = 0;
        for (int i = 0; i < length; ++i) {
            if (valueIndex >= valen) {
                sb.append(StrKit.sub(template, i, length));
                break;
            }
            char currentChar = template.charAt(i);
            if (currentChar == '{') {
                char nextChar;
                if ((nextChar = template.charAt(++i)) == '}') {
                    sb.append(values[valueIndex++]);
                    continue;
                }
                sb.append('{').append(nextChar);
                continue;
            }
            sb.append(currentChar);
        }
        return sb.toString();
    }

    public static String format(String template, Map<?, ?> map) {
        if (null == map || map.isEmpty()) {
            return template;
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            template = template.replace("{" + entry.getKey() + "}", entry.getValue().toString());
        }
        return template;
    }

    public static byte[] bytes(String str, String charset) {
        return StrKit.bytes(str, StrKit.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static byte[] bytes(String str, Charset charset) {
        if (str == null) {
            return null;
        }
        if (null == charset) {
            return str.getBytes();
        }
        return str.getBytes(charset);
    }

    public static String str(byte[] bytes, String charset) {
        return StrKit.str(bytes, StrKit.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String str(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String str(ByteBuffer data, String charset) {
        if (data == null) {
            return null;
        }
        return StrKit.str(data, Charset.forName(charset));
    }

    public static String str(ByteBuffer data, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(data).toString();
    }

    public static ByteBuffer byteBuffer(String str, String charset) {
        return ByteBuffer.wrap(StrKit.bytes(str, charset));
    }

    public static <T> String join(String conjunction, List<T> objs) {
        if (CollectionKit.isEmpty(objs)) {
            return EMPTY;
        }
        return CollectionKit.join(objs, conjunction);
    }

    public static <T> String join(String conjunction, T ... objs) {
        if (CollectionKit.isEmpty(objs)) {
            return EMPTY;
        }
        return CollectionKit.join(conjunction, objs);
    }

    public static String toUnderlineCase(String camelCaseStr) {
        return StrKit.toUnderlineCase(camelCaseStr, UNDERLINE);
    }

    public static String toUnderlineCase(String camelCaseStr, String underline) {
        if (camelCaseStr == null) {
            return null;
        }
        int length = camelCaseStr.length();
        StringBuilder sb = new StringBuilder();
        boolean isPreUpperCase = false;
        for (int i = 0; i < length; ++i) {
            char c = camelCaseStr.charAt(i);
            boolean isNextUpperCase = true;
            if (i < length - 1) {
                isNextUpperCase = Character.isUpperCase(camelCaseStr.charAt(i + 1));
            }
            if (Character.isUpperCase(c)) {
                if (!(isPreUpperCase && isNextUpperCase || i <= 0)) {
                    sb.append(underline);
                }
                isPreUpperCase = true;
            } else {
                isPreUpperCase = false;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String toCamelCase(String name) {
        return StrKit.toCamelCase(name, UNDERLINE);
    }

    public static String toCamelCase(String name, String underline) {
        if (StrKit.isEmpty(name) || StrKit.isEmpty(underline) || !name.contains(underline)) {
            return name;
        }
        if (underline.length() > 1) {
            log.warn("\u8fde\u63a5\u7b26\u957f\u5ea6\u5927\u4e8e1\uff0c\u53ef\u80fd\u5bfc\u81f4\u9a7c\u5cf0\u8f6c\u6362\u9519\u8bef");
        }
        name = name.toLowerCase();
        char under = underline.charAt(0);
        StringBuilder sb = new StringBuilder(name.length());
        boolean upperCase = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == under) {
                upperCase = true;
                continue;
            }
            if (upperCase) {
                sb.append(Character.toUpperCase(c));
                upperCase = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String wrap(String str, String prefix, String suffix) {
        return StrKit.format("{}{}{}", prefix, str, suffix);
    }

    public static boolean isWrap(String str, String prefix, String suffix) {
        return str.startsWith(prefix) && str.endsWith(suffix);
    }

    public static boolean isWrap(String str, String wrapper) {
        return StrKit.isWrap(str, wrapper, wrapper);
    }

    public static boolean isWrap(String str, char wrapper) {
        return StrKit.isWrap(str, wrapper, wrapper);
    }

    public static boolean isWrap(String str, char prefixChar, char suffixChar) {
        return str.charAt(0) == prefixChar && str.charAt(str.length() - 1) == suffixChar;
    }

    public static String padPre(String str, int minLength, char padChar) {
        if (str.length() >= minLength) {
            return str;
        }
        StringBuilder sb = new StringBuilder(minLength);
        for (int i = str.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        sb.append(str);
        return sb.toString();
    }

    public static String padEnd(String str, int minLength, char padChar) {
        if (str.length() >= minLength) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        for (int i = str.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    public static StringBuilder builder() {
        return new StringBuilder();
    }

    public static StringBuilder builder(int capacity) {
        return new StringBuilder(capacity);
    }

    public static StringBuilder builder(String ... strs) {
        StringBuilder sb = new StringBuilder();
        for (String str : strs) {
            sb.append(str);
        }
        return sb;
    }

    public static StringReader getReader(String str) {
        return new StringReader(str);
    }

    public static StringWriter getWriter() {
        return new StringWriter();
    }

    public static byte[] encode(String str, String charset) {
        if (str == null) {
            return null;
        }
        if (StrKit.isBlank(charset)) {
            return str.getBytes();
        }
        try {
            return str.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(StrKit.format("\u4e0d\u652f\u6301\u7684\u5b57\u7b26\u7f16\u7801[{}]\uff01", charset));
        }
    }

    public static String decode(byte[] data, String charset) {
        if (data == null) {
            return null;
        }
        if (StrKit.isBlank(charset)) {
            return new String(data);
        }
        try {
            return new String(data, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(StrKit.format("\u4e0d\u652f\u6301\u7684\u5b57\u7b26\u7f16\u7801[{}]\uff01", charset));
        }
    }
}

