/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.ObjectKit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.lulihu.ObjectKit.CollectionKit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.net.www.protocol.file.FileURLConnection;

public class ResourcesLoadKit {
    private static final Logger log = LoggerFactory.getLogger(ResourcesLoadKit.class);
    private static final Class clazz = ResourcesLoadKit.class;

    public static void loadResourcesFromJarByFolder(String folderPath, String targetFolderPath) throws IOException {
        URL url = clazz.getResource(folderPath);
        URLConnection urlConnection = url.openConnection();
        if (urlConnection instanceof FileURLConnection) {
            ResourcesLoadKit.copyFileResources(url, folderPath, targetFolderPath);
        } else if (urlConnection instanceof JarURLConnection) {
            ResourcesLoadKit.copyJarResources((JarURLConnection)urlConnection, targetFolderPath);
        }
    }

    private static void copyFileResources(URL url, String folderPath, String targetFolderPath) throws IOException {
        File root = new File(url.getPath());
        if (root.isDirectory()) {
            File[] files = root.listFiles();
            if (CollectionKit.isEmpty(files)) {
                return;
            }
            for (File file : files) {
                if (file.isDirectory()) {
                    ResourcesLoadKit.loadResourcesFromJarByFolder(folderPath + "/" + file.getName(), targetFolderPath);
                    continue;
                }
                ResourcesLoadKit.loadResourcesFromJar(folderPath + "/" + file.getName(), targetFolderPath);
            }
        }
    }

    private static void copyJarResources(JarURLConnection jarURLConnection, String targetFolderPath) throws IOException {
        try (JarFile jarFile = jarURLConnection.getJarFile();){
            Enumeration<JarEntry> entrys = jarFile.entries();
            while (entrys.hasMoreElements()) {
                JarEntry entry = entrys.nextElement();
                if (!entry.getName().startsWith(jarURLConnection.getEntryName()) || entry.getName().endsWith("/")) continue;
                ResourcesLoadKit.loadResourcesFromJar("/" + entry.getName(), targetFolderPath);
            }
        }
    }

    private static void loadResourcesFromJar(String path, String targetFolderPath) throws IOException {
        File file;
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("\u8def\u5f84\u5fc5\u987b\u662f\u7edd\u5bf9\u7684\uff08\u4ee5'/'\u5f00\u5934\uff09\u3002");
        }
        if (path.endsWith("/")) {
            throw new IllegalArgumentException("\u8def\u5f84\u5fc5\u987b\u662f\u7edd\u5bf9\u7684\uff08\u4e0d\u4ee5'/'\u7ed3\u5c3e\uff09\u3002");
        }
        int index = path.lastIndexOf(47);
        String filename = path.substring(index + 1);
        String folderPath = targetFolderPath + path.substring(0, index + 1);
        File dir = new File(folderPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!(file = new File(filename = folderPath + filename)).exists() && !file.createNewFile()) {
            log.error("\u521b\u5efa\u6587\u4ef6\u5931\u8d25,\u6587\u4ef6\u540d:{}", (Object)filename);
            return;
        }
        byte[] buffer = new byte[1024];
        try (InputStream is = ResourcesLoadKit.loadResourcesInputStream(path);){
            if (is == null) {
                throw new FileNotFoundException("\u6587\u4ef6 " + path + " \u5728JAR\u91cc\u9762\u627e\u4e0d\u5230");
            }
            try (FileOutputStream os = new FileOutputStream(file);){
                int readBytes;
                while ((readBytes = is.read(buffer)) != -1) {
                    ((OutputStream)os).write(buffer, 0, readBytes);
                }
            }
        }
    }

    public static InputStream loadResourcesInputStream(String path) throws IOException {
        URL url = clazz.getResource(path);
        URLConnection urlConnection = url.openConnection();
        return urlConnection.getInputStream();
    }
}

