/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.ObjectKit;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.lulihu.functional.Consumption;
import net.lulihu.functional.ConsumptionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadWriteLockKit {
    private static final Logger log = LoggerFactory.getLogger(ReadWriteLockKit.class);
    private final Lock readLock;
    private final Lock writeLock;

    public ReadWriteLockKit() {
        this(false);
    }

    public ReadWriteLockKit(boolean fair) {
        ReentrantReadWriteLock globalLock = new ReentrantReadWriteLock(fair);
        this.readLock = globalLock.readLock();
        this.writeLock = globalLock.writeLock();
    }

    public <T> T exeReadLockMethod(ConsumptionResult<T> consumption) {
        try {
            this.readLock.lock();
            T t = consumption.accept();
            return t;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public <T> T exeWriteLockMethod(ConsumptionResult<T> consumption) {
        try {
            this.writeLock.lock();
            T t = consumption.accept();
            return t;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void exeWriteLockMethod(Consumption consumption) {
        try {
            this.writeLock.lock();
            consumption.accept();
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

