/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.ObjectKit;

import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import net.lulihu.ObjectKit.ConfigProperties;
import net.lulihu.ObjectKit.ReflectKit;
import net.lulihu.ObjectKit.StrKit;
import net.lulihu.ObjectKit.annotation.Prop;

public class PropertiesKit {
    private static final Map<String, ConfigProperties> propertiesMap = new ConcurrentHashMap<String, ConfigProperties>();

    private PropertiesKit() {
    }

    public static <T> Properties beanToProperties(T bean) throws IllegalAccessException {
        Objects.requireNonNull(bean);
        Properties result = new Properties();
        List<Field> fields = ReflectKit.getAllFieldsList(bean.getClass());
        String name = null;
        try {
            for (Field field : fields) {
                Prop prop = field.getAnnotation(Prop.class);
                if (prop == null) continue;
                name = field.getName();
                Object value = ReflectKit.getFieldValue(bean, name);
                result.put(prop.value(), value);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessException(StrKit.format("\u975e\u6cd5\u8bbf\u95ee\u5c5e\u6027[{}]\u4f8b\u5916", name));
        }
        return result;
    }

    public static ConfigProperties getDefaultProperties() {
        return PropertiesKit.getConfigProperties("config.properties");
    }

    public static ConfigProperties getConfigProperties(File file) {
        return propertiesMap.computeIfAbsent(file.getPath(), k -> new ConfigProperties(file));
    }

    public static ConfigProperties getConfigProperties(String configFile) {
        return propertiesMap.computeIfAbsent(configFile, ConfigProperties::new);
    }
}

