/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.ObjectKit;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.lulihu.Assert0;
import net.lulihu.ObjectKit.BeanKit;
import net.lulihu.ObjectKit.CollectionKit;
import net.lulihu.ObjectKit.ObjectKit;
import net.lulihu.ObjectKit.ReflectKit;
import net.lulihu.ObjectKit.StrKit;
import net.lulihu.exception.ToolBoxException;
import net.lulihu.functional.MapGroup;

public class MapKit {
    private MapKit() {
    }

    public static <T> T toJavaBean(Map<String, Object> map, T t) {
        return MapKit.toJavaBean(map, t, "_");
    }

    public static <T> T toJavaBean(Map<String, Object> map, T t, String underline) {
        if (MapKit.isNotEmpty(map)) {
            for (Field field : ReflectKit.getAllFieldsList(t.getClass())) {
                String fieldName = field.getName();
                Object v = map.containsKey(fieldName) ? map.get(fieldName) : map.get(StrKit.toUnderlineCase(fieldName, underline));
                if (!ObjectKit.hasNotEmpty(v)) continue;
                ReflectKit.setFieldValue(t, fieldName, v);
            }
        }
        return t;
    }

    public static TreeMap<String, String> toTreeMap(Object obj, Comparator<String> comparator) throws IllegalAccessException {
        TreeMap<String, String> result;
        if (BeanKit.isBean(obj.getClass())) {
            result = MapKit.javaBeanToTreeMap(obj, comparator);
        } else if (obj instanceof Map) {
            result = new TreeMap(comparator);
            Map map = (Map)obj;
            if (MapKit.isEmpty(map)) {
                return result;
            }
            Object key = map.keySet().iterator().next();
            Object value = map.get(key);
            if (!(key instanceof String) || !(value instanceof String)) {
                throw new ToolBoxException("{}<{},{}> \u65e0\u6cd5\u8f6c\u6362\u4e3aTreeMap<String, String>...", obj.getClass().getSimpleName(), key.getClass().getSimpleName(), value.getClass().getSimpleName());
            }
            result.putAll(map);
        } else {
            throw new ToolBoxException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b\u8f6c\u6362...");
        }
        return result;
    }

    public static TreeMap<String, String> javaBeanToTreeMap(Object obj, Comparator<String> comparator) throws IllegalAccessException {
        Assert0.toolBox().notTrue(!BeanKit.isBean(obj.getClass()), "\u8f6c\u6362\u5bf9\u8c61\u5fc5\u987b\u4e3ajavaBean");
        TreeMap<String, String> treeMap = new TreeMap<String, String>(comparator);
        for (Field field : ReflectKit.getAllFieldsList(obj.getClass())) {
            String fieldName = field.getName();
            Object value = ReflectKit.getFieldValue(obj, fieldName);
            if (value == null) continue;
            if (!BeanKit.isPrimitive(value.getClass())) {
                value = JSON.toJSONString((Object)value);
            }
            treeMap.put(fieldName, value.toString());
        }
        return treeMap;
    }

    public static <T, K> HashMap<T, K> toMap(Collection<Map.Entry<T, K>> entryCollection) {
        HashMap<T, K> map = new HashMap<T, K>();
        for (Map.Entry<T, K> entry : entryCollection) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static <O, V> Map<String, V> listToHashMap(List<O> list, MapGroup<O, String, V> mapGroup) {
        return MapKit.listToMap(list, new HashMap(), mapGroup);
    }

    public static <O, K, V> Map<K, V> listToMap(List<O> list, Map<K, V> result, MapGroup<O, K, V> mapGroup) {
        Assert0.toolBox().notNull(result, "\u7ed3\u679c\u5c01\u88c5map\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        if (CollectionKit.isEmpty(list)) {
            return result;
        }
        for (O obj : list) {
            mapGroup.accept(obj, result);
        }
        return result;
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static <T> boolean isNotEmpty(Map<?, ?> map) {
        return !MapKit.isEmpty(map);
    }

    public static <T, K> HashMap<T, K> newHashMap() {
        return new HashMap();
    }

    public static <T, K> HashMap<T, K> newHashMap(int size) {
        return new HashMap((int)((double)size / 0.75));
    }

    public static Map<String, Object> caseInsensitiveMap(Map<String, Object> map) {
        HashMap<String, Object> tempMap = new HashMap<String, Object>();
        for (String key : map.keySet()) {
            tempMap.put(key.toLowerCase(), map.get(key));
        }
        return tempMap;
    }

    public static <K, V> V getFirstOrNull(Map<K, V> map) {
        Map.Entry<K, V> entry;
        V obj = null;
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext() && (obj = (V)(entry = iterator.next()).getValue()) == null) {
        }
        return obj;
    }
}

