/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.ObjectKit;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ImageWatermarkKit {
    private static int R = 255;
    private static int G = 255;
    private static int B = 255;

    public static void strToImage(String outImgPath, Color fontColor, int fontSize, String fontName, int imgWidth, int imgHeight, String waterMarkContent) throws IOException {
        BufferedImage bufImg = new BufferedImage(imgWidth, imgHeight, 1);
        Graphics2D g = bufImg.createGraphics();
        g.drawImage(bufImg, 0, 0, imgWidth, imgHeight, null);
        g.setColor(new Color(R, G, B));
        g.fillRect(0, 0, imgWidth, imgHeight);
        g.setFont(new Font(fontName, 0, fontSize));
        g.setColor(fontColor);
        ImageWatermarkKit.automaticLineBreak(g, waterMarkContent, 0, imgWidth, imgHeight, fontSize);
        g.dispose();
        ImageWatermarkKit.write(outImgPath, bufImg);
    }

    public static void waterPress(String srcImgPath, String outImgPath, Color markContentColor, int fontSize, String waterMarkContent, String fontName) throws IOException {
        File srcImgFile = new File(srcImgPath);
        BufferedImage srcImg = ImageIO.read(srcImgFile);
        int srcImgWidth = ((Image)srcImg).getWidth(null);
        int srcImgHeight = ((Image)srcImg).getHeight(null);
        BufferedImage bufImg = new BufferedImage(srcImgWidth, srcImgHeight, 1);
        Graphics2D g = bufImg.createGraphics();
        g.drawImage(srcImg, 0, 0, srcImgWidth, srcImgHeight, null);
        Font font = new Font(fontName, 0, fontSize);
        g.setColor(markContentColor);
        g.setFont(font);
        ImageWatermarkKit.automaticLineBreak(g, waterMarkContent, 0, srcImgWidth, srcImgHeight, fontSize);
        g.dispose();
        ImageWatermarkKit.write(outImgPath, bufImg);
    }

    private static void automaticLineBreak(Graphics2D g, String waterMarkContent, int x, int srcImgWidth, int srcImgHeight, int fontSize) {
        int tempLineLen = 0;
        int fontLen = ImageWatermarkKit.getWatermarkLength(waterMarkContent, g);
        int line = fontLen / srcImgWidth;
        int tempY = srcImgHeight - (line + 1) * fontSize;
        StringBuilder sb = new StringBuilder();
        int len = waterMarkContent.length();
        for (int i = 0; i < len; ++i) {
            char tempChar = waterMarkContent.charAt(i);
            int tempCharLen = ImageWatermarkKit.getCharLen(tempChar, g);
            if ((tempLineLen += tempCharLen) >= srcImgWidth) {
                g.drawString(sb.toString(), x, tempY);
                sb.delete(x, sb.length());
                tempY += fontSize;
                tempLineLen = 0;
            }
            sb.append(tempChar);
        }
        g.drawString(sb.toString(), 0, tempY);
    }

    private static int getCharLen(char c, Graphics2D g) {
        return g.getFontMetrics(g.getFont()).charWidth(c);
    }

    private static int getWatermarkLength(String waterMarkContent, Graphics2D g) {
        return g.getFontMetrics(g.getFont()).charsWidth(waterMarkContent.toCharArray(), 0, waterMarkContent.length());
    }

    private static void write(String outImgPath, BufferedImage bufImg) throws IOException {
        try (FileOutputStream outImgStream = new FileOutputStream(outImgPath);){
            ImageIO.write((RenderedImage)bufImg, "jpg", outImgStream);
            outImgStream.flush();
        }
    }
}

