/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.ObjectKit;

import net.lulihu.ObjectKit.NativeKit;
import net.lulihu.ObjectKit.StrKit;

public class IDGeneratorKit {
    private static final IdGenerator generator = IdGeneratorEnum.instance.getInstance();

    private IDGeneratorKit() {
    }

    public static Long get() {
        return IDGeneratorKit.generator.nextId();
    }

    public static String getStr() {
        return String.valueOf(IDGeneratorKit.generator.nextId());
    }

    public static enum IdGeneratorEnum {
        instance;

        private IdGenerator generator = new IdGenerator();

        public IdGenerator getInstance() {
            return this.generator;
        }
    }

    private static class ApparatusUtils {
        private final String[] binaryArray = new String[]{"0000", "0001", "0010", "0011", "0100", "0101", "0110", "0111", "1000", "1001", "1010", "1011", "1100", "1101", "1110", "1111"};

        private ApparatusUtils() {
        }

        private long[] getApparatusId() {
            String processorId = NativeKit.CPUSerialNumber();
            StringBuilder builder = this.bytes2BitStr(this.hexStringToByte(processorId));
            long workerId = Integer.valueOf(builder.substring(0, 4), 2).intValue();
            long datacenterId = Integer.valueOf(builder.substring(5, 9), 2).intValue();
            return new long[]{workerId, datacenterId};
        }

        private byte[] hexStringToByte(String hexString) {
            int len = hexString.length() / 2;
            byte[] bytes = new byte[len];
            for (int i = 0; i < len; ++i) {
                String hexStr = "0123456789ABCDEF";
                byte high = (byte)(hexStr.indexOf(hexString.charAt(2 * i)) << 4);
                byte low = (byte)hexStr.indexOf(hexString.charAt(2 * i + 1));
                bytes[i] = (byte)(high | low);
            }
            return bytes;
        }

        private StringBuilder bytes2BitStr(byte[] bArray) {
            StringBuilder builder = new StringBuilder();
            for (byte b : bArray) {
                int pos = (b & 0xF0) >> 4;
                builder.append(this.binaryArray[pos]);
                pos = b & 0xF;
                builder.append(this.binaryArray[pos]);
            }
            return builder;
        }
    }

    private static class IdGenerator {
        private long workerId;
        private long datacenterId;
        private long sequence = 0L;
        private long twepoch;
        private long workerIdBits = 5L;
        private long datacenterIdBits = 5L;
        long maxWorkerId;
        private long sequenceBits;
        private long workerIdShift = this.sequenceBits = 12L;
        private long datacenterIdShift = this.sequenceBits + this.workerIdBits;
        private long timestampLeftShift = this.sequenceBits + this.workerIdBits + this.datacenterIdBits;
        private long sequenceMask = -1L << (int)this.sequenceBits ^ 0xFFFFFFFFFFFFFFFFL;
        private long lastTimestamp = -1L;

        private IdGenerator() {
            ApparatusUtils apparatusUtils = new ApparatusUtils();
            long[] apparatusId = apparatusUtils.getApparatusId();
            long workerId = apparatusId[0];
            this.maxWorkerId = -1L << (int)this.workerIdBits ^ 0xFFFFFFFFFFFFFFFFL;
            if (workerId > this.maxWorkerId || workerId < 0L) {
                throw new IllegalArgumentException(String.format("worker Id \u4e0d\u80fd\u5927\u4e8e %d \u6216\u8005\u5c0f\u4e8e 0", this.maxWorkerId));
            }
            long datacenterId = apparatusId[1];
            long maxDatacenterId = -1L << (int)this.datacenterIdBits ^ 0xFFFFFFFFFFFFFFFFL;
            if (datacenterId > maxDatacenterId || datacenterId < 0L) {
                throw new IllegalArgumentException(String.format("datacenter Id \u4e0d\u80fd\u5927\u4e8e %d \u6216\u8005\u5c0f\u4e8e 0", maxDatacenterId));
            }
            this.workerId = workerId;
            this.datacenterId = datacenterId;
            this.twepoch = 1288834974657L;
        }

        private synchronized long nextId() {
            long timestamp = this.timeGen();
            if (timestamp < this.lastTimestamp) {
                throw new RuntimeException(StrKit.format("\u65f6\u949f\u5012\u9000\u3002 \u62d2\u7edd\u4e3a {} \u6beb\u79d2\u751f\u6210ID", this.lastTimestamp - timestamp));
            }
            if (this.lastTimestamp == timestamp) {
                this.sequence = this.sequence + 1L & this.sequenceMask;
                if (this.sequence == 0L) {
                    timestamp = this.tilNextMillis(this.lastTimestamp);
                }
            } else {
                this.sequence = 0L;
            }
            this.lastTimestamp = timestamp;
            return timestamp - this.twepoch << (int)this.timestampLeftShift | this.datacenterId << (int)this.datacenterIdShift | this.workerId << (int)this.workerIdShift | this.sequence;
        }

        private long tilNextMillis(long lastTimestamp) {
            long timestamp = this.timeGen();
            while (timestamp <= lastTimestamp) {
                timestamp = this.timeGen();
            }
            return timestamp;
        }

        private long timeGen() {
            return System.currentTimeMillis();
        }
    }
}

