/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.ObjectKit;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Set;
import net.lulihu.ObjectKit.BasicType;
import net.lulihu.ObjectKit.CollectionKit;
import net.lulihu.ObjectKit.StrKit;
import net.lulihu.dateTime.DateTimeKit;
import net.lulihu.exception.ToolBoxException;

public class ConvertKit {
    private static final String[] fraction = new String[]{"\u89d2", "\u5206"};
    private static final String[] digit = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[][] unit = new String[][]{{"\u5143", "\u4e07", "\u4ebf"}, {"", "\u62fe", "\u4f70", "\u4edf"}};

    private ConvertKit() {
    }

    public static Object parse(Class<?> clazz, Object value) {
        try {
            if (clazz.isAssignableFrom(String.class)) {
                if (StrKit.isBlank(String.valueOf(value))) {
                    return " ";
                }
                return String.valueOf(value);
            }
            return clazz.cast(value);
        }
        catch (ClassCastException e) {
            String valueStr = String.valueOf(value);
            Object result = ConvertKit.parseBasic(clazz, valueStr);
            if (result != null) {
                return result;
            }
            if (Date.class.isAssignableFrom(clazz)) {
                return DateTimeKit.parse(valueStr).toDate();
            }
            if (clazz == BigInteger.class) {
                return new BigInteger(valueStr);
            }
            if (clazz == BigDecimal.class) {
                return new BigDecimal(valueStr);
            }
            if (clazz == byte[].class) {
                return valueStr.getBytes();
            }
            return new ToolBoxException("\u672a\u627e\u5230\u53ef\u8f6c\u6362\u7684\u7c7b\u578b...");
        }
    }

    public static Object parseBasic(Class<?> clazz, String valueStr) {
        BasicType basicType;
        if (null == clazz || null == valueStr) {
            return null;
        }
        if (StrKit.isBlank(valueStr)) {
            return null;
        }
        try {
            basicType = BasicType.valueOf(clazz.getSimpleName().toUpperCase());
        }
        catch (Exception e) {
            return null;
        }
        switch (basicType) {
            case BYTE: {
                if (clazz == Byte.TYPE) {
                    return Byte.parseByte(valueStr);
                }
                return Byte.valueOf(valueStr);
            }
            case SHORT: {
                if (clazz == Short.TYPE) {
                    return Short.parseShort(valueStr);
                }
                return Short.valueOf(valueStr);
            }
            case INT: {
                return Integer.parseInt(valueStr);
            }
            case INTEGER: {
                return Integer.valueOf(valueStr);
            }
            case LONG: {
                if (clazz == Long.TYPE) {
                    return new BigDecimal(valueStr).longValue();
                }
                return Long.valueOf(valueStr);
            }
            case DOUBLE: {
                if (clazz == Double.TYPE) {
                    return new BigDecimal(valueStr).doubleValue();
                }
            }
            case FLOAT: {
                if (clazz == Float.TYPE) {
                    return Float.valueOf(Float.parseFloat(valueStr));
                }
                return Float.valueOf(valueStr);
            }
            case BOOLEAN: {
                if (clazz == Boolean.TYPE) {
                    return Boolean.parseBoolean(valueStr);
                }
                return Boolean.valueOf(valueStr);
            }
            case CHAR: {
                return Character.valueOf(valueStr.charAt(0));
            }
            case CHARACTER: {
                return Character.valueOf(valueStr.charAt(0));
            }
        }
        return null;
    }

    public static String toStr(Object value, String defaultValue) {
        if (null == value) {
            return defaultValue;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (CollectionKit.isArray(value)) {
            return CollectionKit.toString(value);
        }
        return value.toString();
    }

    public static String toStr(Object value) {
        return ConvertKit.toStr(value, null);
    }

    public static Character toChar(Object value, Character defaultValue) {
        if (null == value) {
            return defaultValue;
        }
        if (value instanceof Character) {
            return (Character)value;
        }
        String valueStr = ConvertKit.toStr(value, null);
        return Character.valueOf(StrKit.isEmpty(valueStr) ? defaultValue.charValue() : valueStr.charAt(0));
    }

    public static Character toChar(Object value) {
        return ConvertKit.toChar(value, null);
    }

    public static Byte toByte(Object value, Byte defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        String valueStr = ConvertKit.toStr(value, null);
        if (StrKit.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return Byte.parseByte(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Byte toByte(Object value) {
        return ConvertKit.toByte(value, null);
    }

    public static Short toShort(Object value, Short defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        String valueStr = ConvertKit.toStr(value, null);
        if (StrKit.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return Short.parseShort(valueStr.trim());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Short toShort(Object value) {
        return ConvertKit.toShort(value, null);
    }

    public static Number toNumber(Object value, Number defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        String valueStr = ConvertKit.toStr(value, null);
        if (StrKit.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return NumberFormat.getInstance().parse(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Number toNumber(Object value) {
        return ConvertKit.toNumber(value, null);
    }

    public static Integer toInt(Object value, Integer defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        String valueStr = ConvertKit.toStr(value, null);
        if (StrKit.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(valueStr.trim());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Integer toInt(Object value) {
        return ConvertKit.toInt(value, null);
    }

    public static Integer[] toIntArray(boolean isIgnoreConvertError, Object ... values) {
        if (CollectionKit.isEmpty(values)) {
            return new Integer[0];
        }
        Integer[] ints = new Integer[values.length];
        for (int i = 0; i < values.length; ++i) {
            Integer v = ConvertKit.toInt(values[i], null);
            if (null == v && !isIgnoreConvertError) {
                throw new ToolBoxException(StrKit.format("\u5c06[{}]\u8f6c\u6362\u4e3aInteger\u7c7b\u578b\u9519\u8bef\uff01", values[i]));
            }
            ints[i] = v;
        }
        return ints;
    }

    public static Integer[] toIntArray(String str) {
        return ConvertKit.toIntArray(",", str);
    }

    public static Integer[] toIntArray(String split, String str) {
        if (StrKit.isEmpty(str)) {
            return new Integer[0];
        }
        String[] arr = str.split(split);
        Integer[] ints = new Integer[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            Integer v;
            ints[i] = v = ConvertKit.toInt(arr[i], 0);
        }
        return ints;
    }

    public static String[] toStrArray(String str) {
        return ConvertKit.toStrArray("", str);
    }

    public static String[] toStrArray(String split, String str) {
        return str.split(split);
    }

    public static Long toLong(Object value, Long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        String valueStr = ConvertKit.toStr(value, null);
        if (StrKit.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(valueStr.trim()).longValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Long toLong(Object value) {
        return ConvertKit.toLong(value, null);
    }

    public static Long[] toLongArray(boolean isIgnoreConvertError, Object ... values) {
        if (CollectionKit.isEmpty(values)) {
            return new Long[0];
        }
        Long[] longs = new Long[values.length];
        for (int i = 0; i < values.length; ++i) {
            Long v = ConvertKit.toLong(values[i], null);
            if (null == v && !isIgnoreConvertError) {
                throw new ToolBoxException(StrKit.format("\u5c06[{}]\u8f6c\u6362\u4e3aLong\u7c7b\u578b\u9519\u8bef\uff01", values[i]));
            }
            longs[i] = v;
        }
        return longs;
    }

    public static Double toDouble(Object value, Double defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        String valueStr = ConvertKit.toStr(value, null);
        if (StrKit.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(valueStr.trim()).doubleValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Double toDouble(Object value) {
        return ConvertKit.toDouble(value, null);
    }

    public static Double[] toDoubleArray(boolean isIgnoreConvertError, Object ... values) {
        if (CollectionKit.isEmpty(values)) {
            return new Double[0];
        }
        Double[] doubles = new Double[values.length];
        for (int i = 0; i < values.length; ++i) {
            Double v = ConvertKit.toDouble(values[i], null);
            if (null == v && !isIgnoreConvertError) {
                throw new ToolBoxException(StrKit.format("\u8f6c\u6362[{}]\u4e3aDouble\u7c7b\u578b\u65f6\u53d1\u751f\u4f8b\u5916!", values[i]));
            }
            doubles[i] = v;
        }
        return doubles;
    }

    public static Float toFloat(Object value, Float defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        String valueStr = ConvertKit.toStr(value, null);
        if (StrKit.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return Float.valueOf(Float.parseFloat(valueStr.trim()));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Float toFloat(Object value) {
        return ConvertKit.toFloat(value, null);
    }

    public static <T> Float[] toFloatArray(boolean isIgnoreConvertError, Object ... values) {
        if (CollectionKit.isEmpty(values)) {
            return new Float[0];
        }
        Float[] floats = new Float[values.length];
        for (int i = 0; i < values.length; ++i) {
            Float v = ConvertKit.toFloat(values[i], null);
            if (null == v && !isIgnoreConvertError) {
                throw new ToolBoxException(StrKit.format("\u8f6c\u6362[{}]\u4e3aFloat\u7c7b\u578b\u65f6\u53d1\u751f\u4f8b\u5916!", values[i]));
            }
            floats[i] = v;
        }
        return floats;
    }

    public static Boolean toBool(Object value, Boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        String valueStr = ConvertKit.toStr(value, null);
        if (StrKit.isBlank(valueStr)) {
            return defaultValue;
        }
        switch (valueStr = valueStr.trim().toLowerCase()) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
            case "yes": {
                return true;
            }
            case "ok": {
                return true;
            }
            case "no": {
                return false;
            }
            case "1": {
                return true;
            }
            case "0": {
                return false;
            }
        }
        return defaultValue;
    }

    public static Boolean toBool(Object value) {
        return ConvertKit.toBool(value, null);
    }

    public static Boolean[] toBooleanArray(boolean isIgnoreConvertError, Object ... values) {
        if (CollectionKit.isEmpty(values)) {
            return new Boolean[0];
        }
        Boolean[] bools = new Boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            Boolean v = ConvertKit.toBool(values[i], null);
            if (null == v && !isIgnoreConvertError) {
                throw new ToolBoxException(StrKit.format("\u8f6c\u6362[{}]\u4e3aBoolean\u7c7b\u578b\u65f6\u53d1\u751f\u4f8b\u5916!", values[i]));
            }
            bools[i] = v;
        }
        return bools;
    }

    public static <E extends Enum<E>> E toEnum(Class<E> clazz, Object value, E defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (clazz.isAssignableFrom(value.getClass())) {
            return (E)((Enum)value);
        }
        String valueStr = ConvertKit.toStr(value, null);
        if (StrKit.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(clazz, valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static <E extends Enum<E>> E toEnum(Class<E> clazz, Object value) {
        return ConvertKit.toEnum(clazz, value, null);
    }

    public static BigInteger toBigInteger(Object value, BigInteger defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Long) {
            return BigInteger.valueOf((Long)value);
        }
        String valueStr = ConvertKit.toStr(value, null);
        if (StrKit.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigInteger(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static BigInteger toBigInteger(Object value) {
        return ConvertKit.toBigInteger(value, null);
    }

    public static BigDecimal toBigDecimal(Object value, BigDecimal defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Long) {
            return new BigDecimal((Long)value);
        }
        if (value instanceof Double) {
            return new BigDecimal((Double)value);
        }
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value);
        }
        String valueStr = ConvertKit.toStr(value, null);
        if (StrKit.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static BigDecimal toBigDecimal(Object value) {
        return ConvertKit.toBigDecimal(value, null);
    }

    public static String toSBC(String input) {
        return ConvertKit.toSBC(input, null);
    }

    public static String toSBC(String input, Set<Character> notConvertSet) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (null != notConvertSet && notConvertSet.contains(Character.valueOf(c[i]))) continue;
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (c[i] >= '\u007f') continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static String toDBC(String input) {
        return ConvertKit.toDBC(input, null);
    }

    public static String toDBC(String text, Set<Character> notConvertSet) {
        char[] c = text.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (null != notConvertSet && notConvertSet.contains(Character.valueOf(c[i]))) continue;
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            if (c[i] <= '\uff00' || c[i] >= '\uff5f') continue;
            c[i] = (char)(c[i] - 65248);
        }
        return new String(c);
    }

    public static String strToUnicode(String strText) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < strText.length(); ++i) {
            char c;
            char intAsc = c = strText.charAt(i);
            String strHex = Integer.toHexString(intAsc);
            if (intAsc > '\u0080') {
                str.append("\\u").append(strHex);
                continue;
            }
            str.append("\\u00").append(strHex);
        }
        return str.toString();
    }

    public static String unicodeToStr(String hex) {
        int t = hex.length() / 6;
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < t; ++i) {
            String s = hex.substring(i * 6, (i + 1) * 6);
            String s1 = s.substring(2, 4) + "00";
            String s2 = s.substring(4);
            int n = Integer.valueOf(s1, 16) + Integer.valueOf(s2, 16);
            char[] chars = Character.toChars(n);
            str.append(new String(chars));
        }
        return str.toString();
    }

    public static String convertCharset(String str, String sourceCharset, String destCharset) {
        if (StrKit.hasBlank(str, sourceCharset, destCharset)) {
            return str;
        }
        try {
            return new String(str.getBytes(sourceCharset), destCharset);
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public static String digitUppercase(double n) {
        String head = n < 0.0 ? "\u8d1f" : "";
        n = Math.abs(n);
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < fraction.length; ++i) {
            s.append((digit[(int)(Math.floor(n * 10.0 * Math.pow(10.0, i)) % 10.0)] + fraction[i]).replaceAll("(\u96f6.)+", ""));
        }
        if (s.length() < 1) {
            s = new StringBuilder("\u6574");
        }
        int integerPart = (int)Math.floor(n);
        for (int i = 0; i < unit[0].length && integerPart > 0; ++i) {
            String p = "";
            for (int j = 0; j < unit[1].length && n > 0.0; ++j) {
                p = digit[integerPart % 10] + unit[1][j] + p;
                integerPart /= 10;
            }
            s.insert(0, p.replaceAll("(\u96f6.)*\u96f6$", "").replaceAll("^$", "\u96f6") + unit[0][i]);
        }
        return head + s.toString().replaceAll("(\u96f6.)*\u96f6\u5143", "\u5143").replaceFirst("(\u96f6.)+", "").replaceAll("(\u96f6.)+", "\u96f6").replaceAll("^\u6574$", "\u96f6\u5143\u6574");
    }
}

