/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.ObjectKit;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Properties;
import net.lulihu.exception.ToolBoxException;

public class ConfigProperties {
    private Properties configuration = new Properties();

    public ConfigProperties(String configFile) {
        this.initConfig(configFile);
    }

    public ConfigProperties(File file) {
        this.initConfig(file);
    }

    private void initConfig(File file) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            this.initConfig(inputStream);
        }
        catch (IOException ex) {
            throw new ToolBoxException(ex, "\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6[{}]\u53d1\u9001\u4f8b\u5916", file.getPath());
        }
    }

    private void initConfig(String configFile) {
        try (InputStream inputStream = Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream(configFile), "\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728...");){
            this.initConfig(inputStream);
        }
        catch (IOException ex) {
            throw new ToolBoxException(ex, "\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6[{}]\u53d1\u9001\u4f8b\u5916", configFile);
        }
    }

    private void initConfig(InputStream inputStream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, Charset.forName("GBK"));){
            this.configuration.load(reader);
        }
    }

    public String getStringValue(String key, String defaultValue) {
        String value = this.getProperty(key);
        return value == null ? defaultValue : value;
    }

    public String getStringValue(String key) {
        String value = this.getProperty(key);
        if (value != null) {
            return value;
        }
        throw new NullPointerException("[" + key + "]\u4e0d\u5b58\u5728\u6307\u5b9a\u952e\u7684\u503c...");
    }

    public Integer getIntValue(String key, int defaultValue) {
        String value = this.getProperty(key);
        if (value != null && value.length() > 0) {
            return Integer.valueOf(value);
        }
        return defaultValue;
    }

    public Integer getIntValue(String key) {
        String property = this.getStringValue(key);
        return Integer.valueOf(property);
    }

    public Double getDoubleValue(String key) {
        String property = this.getStringValue(key);
        return Double.valueOf(property);
    }

    public Double getDoubleValue(String key, Double defaultValue) {
        String value = this.getProperty(key);
        if (value != null && value.length() > 0) {
            return Double.valueOf(value);
        }
        return defaultValue;
    }

    public Long getLongValue(String key) {
        String property = this.getStringValue(key);
        return Long.valueOf(property);
    }

    public Long getLongValue(String key, Long defaultValue) {
        String value = this.getProperty(key);
        if (value != null && value.length() > 0) {
            return Long.valueOf(value);
        }
        return defaultValue;
    }

    public Boolean getBooleanValue(String key) {
        String property = this.getStringValue(key);
        return Boolean.valueOf(property);
    }

    public Boolean getBooleanValue(String key, Boolean defaultValue) {
        String value = this.getProperty(key);
        if (value != null && value.length() > 0) {
            return Boolean.valueOf(value);
        }
        return defaultValue;
    }

    private String getProperty(String key) {
        return this.configuration.getProperty(key);
    }
}

