/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.ObjectKit;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.lulihu.Assert0;
import net.lulihu.ObjectKit.BasicType;
import net.lulihu.ObjectKit.BeanKit;
import net.lulihu.ObjectKit.CollectionKit;
import net.lulihu.ObjectKit.ObjectKit;
import net.lulihu.ObjectKit.StrKit;
import net.lulihu.exception.ToolBoxException;

public class ClassKit {
    private static final Map<Class<?>, Class<?>[]> actualTypeArgument = new ConcurrentHashMap();

    private ClassKit() {
    }

    public static Class<?>[] getActualTypeArgument(Class<?> clazz) {
        return actualTypeArgument.computeIfAbsent(clazz, k -> {
            Type[] actualTypeArguments;
            Class[] resultClass = null;
            Type genericSuperclass = clazz.getGenericSuperclass();
            if (genericSuperclass instanceof ParameterizedType && CollectionKit.isEmpty(actualTypeArguments = ((ParameterizedType)genericSuperclass).getActualTypeArguments())) {
                int length = actualTypeArguments.length;
                resultClass = new Class[length];
                for (int i = 0; i < length; ++i) {
                    resultClass[i] = (Class)actualTypeArguments[i];
                }
            }
            return resultClass;
        });
    }

    public static boolean isNormalClass(Class<?> clazz) {
        return null != clazz && !clazz.isInterface() && !ClassKit.isAbstract(clazz) && !clazz.isEnum() && !clazz.isArray() && !clazz.isAnnotation() && !clazz.isSynthetic() && !clazz.isPrimitive();
    }

    public static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static <T> T newInstance(String clazz) {
        if (null == clazz) {
            return null;
        }
        try {
            return (T)Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            throw new ToolBoxException(StrKit.format("\u5b9e\u4f8b\u7c7b [{}] \u9519\u8bef!!", clazz), e);
        }
    }

    public static <T> T newInstanceConstructorsDefaultValue(Class<T> clazz) {
        if (null == clazz) {
            return null;
        }
        Constructor<T> constructor = ClassKit.priorityNoArgumentConstructor(clazz);
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        if (CollectionKit.isEmpty(parameterTypes)) {
            return ClassKit.newInstance(clazz);
        }
        int length = parameterTypes.length;
        Object[] args = new Object[length];
        for (int i = 0; i < length; ++i) {
            Class<?> cla = parameterTypes[i];
            args[i] = BeanKit.isPrimitive(cla) ? ObjectKit.primitiveDefaultValue(cla) : null;
        }
        try {
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new ToolBoxException(StrKit.format("\u5b9e\u4f8b\u7c7b [{}] \u9519\u8bef!", clazz), e);
        }
    }

    public static <T> Constructor<T> priorityNoArgumentConstructor(Class<T> clazz) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = clazz.getDeclaredConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (!CollectionKit.isEmpty(parameterTypes)) continue;
            return constructor;
        }
        return constructors[0];
    }

    public static <T> T newInstance(Class<T> clazz) {
        if (null == clazz) {
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new ToolBoxException(StrKit.format("\u5b9e\u4f8b\u7c7b [{}] \u9519\u8bef!", clazz), e);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) {
        if (null == clazz) {
            return null;
        }
        if (CollectionKit.isEmpty(params)) {
            return ClassKit.newInstance(clazz);
        }
        try {
            return clazz.getDeclaredConstructor(ClassKit.getClasses(params)).newInstance(params);
        }
        catch (Exception e) {
            throw new ToolBoxException(StrKit.format("\u5b9e\u4f8b\u7c7b [{}] \u53d1\u751f\u4f8b\u5916!", clazz), e);
        }
    }

    public static Class<?>[] getClasses(Object ... objects) {
        Class[] classes = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            classes[i] = objects[i].getClass();
        }
        return classes;
    }

    public static boolean isAssignable(Class<?> targetType, Class<?> sourceType) {
        if (null == targetType || null == sourceType) {
            return false;
        }
        if (targetType.isAssignableFrom(sourceType)) {
            return true;
        }
        if (targetType.isPrimitive()) {
            Class<?> resolvedPrimitive = BasicType.wrapperPrimitiveMap.get(sourceType);
            return targetType == resolvedPrimitive;
        }
        Class<?> resolvedWrapper = BasicType.primitiveWrapperMap.get(sourceType);
        return resolvedWrapper != null && targetType.isAssignableFrom(resolvedWrapper);
    }

    public static Method setAccessible(Method method) {
        if (null != method && ClassKit.isNotPublic(method)) {
            method.setAccessible(true);
        }
        return method;
    }

    public static boolean isNotPublic(Class<?> clazz) {
        return !ClassKit.isPublic(clazz);
    }

    public static boolean isNotPublic(Method method) {
        return !ClassKit.isPublic(method);
    }

    public static boolean isPublic(Class<?> clazz) {
        Assert0.toolBox().notNull(clazz, "\u63d0\u4f9b\u7684\u7c7b\u4e3anull");
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isPublic(Method method) {
        Assert0.toolBox().notNull(method, "\u63d0\u4f9b\u7684\u65b9\u6cd5\u4e3anull");
        return ClassKit.isPublic(method.getDeclaringClass());
    }

    public static Class<?> getSuperclass(Object obj) {
        return ClassKit.getSuperclass(obj.getClass());
    }

    public static Class<?> getSuperclass(Class<?> clazz) {
        if (clazz == Object.class) {
            return null;
        }
        Class<?> superclass = clazz.getSuperclass();
        Class<?> aClass = ClassKit.getSuperclass(superclass);
        if (aClass == null) {
            return clazz;
        }
        return ClassKit.getSuperclass(aClass);
    }
}

