/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu;

import net.lulihu.ObjectKit.ObjectKit;

public interface AssertBehavior {
    public void newException(String var1);

    public void newException(String var1, Object ... var2);

    default public AssertBehavior notTrue(boolean boo, String exceptionMessage) {
        if (boo) {
            this.newException(exceptionMessage);
        }
        return this;
    }

    default public AssertBehavior notTrue(boolean boo, String template, Object ... args) {
        if (boo) {
            this.newException(template, args);
        }
        return this;
    }

    default public AssertBehavior notNull(Object obj, String exceptionMessage) {
        return this.notTrue(obj == null, exceptionMessage);
    }

    default public AssertBehavior notNull(Object obj, String template, Object ... args) {
        return this.notTrue(obj == null, template, args);
    }

    default public AssertBehavior notEmpty(Object obj, String template, Object ... args) {
        return this.notTrue(ObjectKit.hasEmpty(obj), template, args);
    }

    default public AssertBehavior foundClass(String fullClassName, String errorMessage) {
        try {
            Class.forName(fullClassName, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            this.newException(errorMessage);
        }
        return this;
    }

    default public AssertBehavior foundClass(String fullClassName, String template, Object ... args) {
        try {
            Class.forName(fullClassName, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            this.newException(template, args);
        }
        return this;
    }
}

