package net.lulihu.http.builder;

import okhttp3.Interceptor;
import okhttp3.Response;

import java.io.IOException;

/**
 * 响应拦截器
 */
public abstract class ResponseInterceptor implements Interceptor {

    @Override
    public final Response intercept(Chain chain) throws IOException {
        Response response = chain.proceed(chain.request());
        return intercept(response);
    }


    /**
     * 拦截方法 返回一个新的响应对象
     *
     * @param response 请求对象
     * @return {@linkplain Response}
     */
    abstract Response intercept(Response response);

}
