package net.lulihu.http.builder;

import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

import java.io.IOException;

/**
 * 请求拦截器
 */
public abstract class RequestInterceptor implements Interceptor {

    @Override
    public final Response intercept(Chain chain) throws IOException {
        Request request = intercept(chain.request());
        return chain.proceed(request);
    }


    /**
     * 拦截方法 返回一个新的请求对象
     *
     * @param request 请求对象
     * @return {@linkplain Request}
     */
    abstract Request intercept(Request request);

}
