package net.lulihu;

import net.lulihu.ObjectKit.StrKit;
import net.lulihu.exception.ToolBoxException;

/**
 * 断言对象
 */
public abstract class Assert0 {

    private static Argument argument;
    private static ToolBox toolBox;

    /**
     * 非法论证
     * <p>
     * 断言失败时则抛出 {@linkplain IllegalArgumentException} 例外
     */
    public static Argument argument() {
        if (argument == null) {
            synchronized (Assert0.class) {
                if (argument == null) argument = new Argument();
            }
        }
        return argument;
    }


    /**
     * 工具论证
     * <p>
     * 断言失败时则抛出 {@linkplain ToolBoxException} 例外
     */
    public static ToolBox toolBox() {
        if (toolBox == null) {
            synchronized (Assert0.class) {
                if (toolBox == null) toolBox = new ToolBox();
            }
        }
        return toolBox;
    }

    /**
     * 工具论证
     * <p>
     * 断言失败时则抛出 {@linkplain ToolBoxException} 例外
     */
    public static class ToolBox implements AssertBehavior {
        private ToolBox() {
        }

        @Override
        public void newException(String errorMessage) {
            throw new ToolBoxException(errorMessage);
        }

        @Override
        public void newException(String template, Object... args) {
            throw new ToolBoxException(template, args);
        }
    }


    /**
     * 非法论证
     * <p>
     * 断言失败时则抛出 {@linkplain IllegalArgumentException} 例外
     */
    public static class Argument implements AssertBehavior {

        private Argument() {
        }

        @Override
        public void newException(String errorMessage) {
            throw new IllegalArgumentException(errorMessage);
        }

        @Override
        public void newException(String template, Object... args) {
            newException(StrKit.format(template, args));
        }
    }

}
