/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.promise;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.lulihu.promise.Promise;

public class Async {
    private static final ExecutorService defaultExecutor;

    public static void shutdown() {
        defaultExecutor.shutdownNow();
    }

    public static <V> Promise<V> submit(Callable<V> callable) {
        return Async.submit(callable, defaultExecutor);
    }

    public static <V> Promise<V> submit(Callable<V> callable, ExecutorService executorService) {
        Promise promise = new Promise();
        Callable<Object> smarterCallable = () -> {
            try {
                Object result = callable.call();
                promise.invoke(result);
                return result;
            }
            catch (Throwable e) {
                promise.invokeWithException(e);
                return null;
            }
        };
        executorService.submit(smarterCallable);
        return promise;
    }

    static {
        int cores = Runtime.getRuntime().availableProcessors();
        defaultExecutor = Executors.newFixedThreadPool(cores);
    }
}

