/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.office.excel;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import net.lulihu.Assert;
import net.lulihu.ObjectKit.FileKit;
import net.lulihu.ObjectKit.MapKit;
import net.lulihu.office.excel.Excel;
import net.lulihu.office.excel.ExcelAnalysis;
import net.lulihu.office.excel.ExcelReadHandle;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelKit {
    public static LinkedHashMap<String, ExcelReadHandle> excelReadInFile(String filePath, HashMap<Integer, Integer[]> continueRowMap) throws IOException {
        Assert.isTrue(FileKit.isEmpty(filePath), "\u6587\u4ef6\u4e0d\u5b58\u5728");
        LinkedHashMap<String, List<List<String>>> excelData = null;
        try {
            FileInputStream inputStream = new FileInputStream(filePath);
            Object object = null;
            try {
                excelData = ExcelAnalysis.importForExcelData((Workbook)new XSSFWorkbook((InputStream)inputStream), continueRowMap);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (inputStream != null) {
                    if (object != null) {
                        try {
                            ((InputStream)inputStream).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)inputStream).close();
                    }
                }
            }
        }
        catch (FileNotFoundException inputStream) {
            // empty catch block
        }
        LinkedHashMap<String, ExcelReadHandle> result = new LinkedHashMap<String, ExcelReadHandle>();
        if (MapKit.isEmpty(excelData)) {
            return result;
        }
        for (String key : excelData.keySet()) {
            result.put(key, new ExcelReadHandle(excelData.get(key)));
        }
        return result;
    }

    public static void excelWriteToFile(Excel excel, String filePath) throws Exception {
        Assert.notNull((Object)excel, "\u5bfc\u51fa\u6570\u636e\u5bf9\u8c61\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        Assert.notNull(filePath, "\u6587\u4ef6\u8def\u5f84\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        ExcelAnalysis excelUtils = new ExcelAnalysis();
        excelUtils.setDataLists(excel.getData());
        excelUtils.setSheetName(excel.getSheetName());
        excelUtils.setLabelName(excel.labelFirstMerge());
        excelUtils.setFilePath(filePath);
        excelUtils.exportForExcelsOptimize();
    }

    public static void excelWriteToResponse(HttpServletResponse response, Excel excel, String fileName) throws Exception {
        Assert.notNull((Object)response, "\u54cd\u5e94\u4f53\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        Assert.notNull((Object)excel, "\u5bfc\u51fa\u6570\u636e\u5bf9\u8c61\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        Assert.notNull(fileName, "\u6587\u4ef6\u540d\u79f0\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        ExcelAnalysis excelUtils = new ExcelAnalysis();
        excelUtils.setDataLists(excel.getData());
        excelUtils.setSheetName(excel.getSheetName());
        excelUtils.setLabelName(excel.labelFirstMerge());
        excelUtils.setFileName(fileName);
        excelUtils.setResponse(response);
        excelUtils.exportForExcelsOptimize();
    }
}

