/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.lock;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import net.lulihu.dataStructure.LRULinkedHashMap;
import net.lulihu.lock.ConditionLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderExecuteLockKit {
    private static final Logger log = LoggerFactory.getLogger(OrderExecuteLockKit.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final AtomicInteger incrementalSignal = new AtomicInteger(0);
    private final LRULinkedHashMap<Integer, Condition> incrementalSignalMap = new LRULinkedHashMap();

    public synchronized ConditionLock getConditionLock() {
        int incremental = this.incrementalSignal.incrementAndGet();
        Condition condition = this.lock.newCondition();
        this.incrementalSignalMap.put(incremental, condition);
        return new ConditionLock(incremental, condition, this);
    }

    void getLock() {
        this.lock.lock();
    }

    void unlock() {
        this.lock.unlock();
    }

    LRULinkedHashMap<Integer, Condition> getIncrementalSignalMap() {
        return this.incrementalSignalMap;
    }
}

