/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.jdbc.orm;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.lulihu.ObjectKit.ClassKit;
import net.lulihu.ObjectKit.CollectionKit;
import net.lulihu.ObjectKit.LogKit;
import net.lulihu.dateTime.DateTimeKit;
import net.lulihu.exception.ToolBoxException;
import net.lulihu.jdbc.orm.QueryResultSetKit;
import net.lulihu.jdbc.orm.SqlStatementExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSqlStatementExecutor
implements SqlStatementExecutor {
    private static final Logger log = LoggerFactory.getLogger(DefaultSqlStatementExecutor.class);
    private static final DefaultSqlStatementExecutor defaultSqlStatementExecutor = new DefaultSqlStatementExecutor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer executeInsertAndReturnId(Connection connection, String sql, Object ... params) throws SQLException {
        ResultSet resultSet;
        PreparedStatement ps;
        int row;
        Long afterExecute;
        Long beforeExecute;
        block12: {
            beforeExecute = null;
            afterExecute = null;
            row = 0;
            ps = null;
            resultSet = null;
            try {
                ps = connection.prepareStatement(sql, 1);
                this.statementReplacement(ps, params);
                if (log.isDebugEnabled()) {
                    beforeExecute = DateTimeKit.current(false);
                }
                if ((row = ps.executeUpdate()) != 1) {
                    throw new ToolBoxException("\u6570\u636e\u4fdd\u5b58\u5931\u8d25...");
                }
                resultSet = ps.getGeneratedKeys();
                if (!resultSet.next()) break block12;
                Integer n = resultSet.getInt(1);
                if (resultSet != null) {
                    this.close(resultSet);
                }
                if (ps != null) {
                    this.close(ps);
                }
                this.sqlLog(sql, beforeExecute, afterExecute, row, params);
                return n;
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    this.close(resultSet);
                }
                if (ps != null) {
                    this.close(ps);
                }
                this.sqlLog(sql, beforeExecute, afterExecute, row, params);
                throw throwable;
            }
        }
        if (log.isDebugEnabled()) {
            afterExecute = DateTimeKit.current(false);
        }
        if (resultSet != null) {
            this.close(resultSet);
        }
        if (ps != null) {
            this.close(ps);
        }
        this.sqlLog(sql, beforeExecute, afterExecute, row, params);
        throw new ToolBoxException("\u83b7\u53d6\u81ea\u589e\u4e3b\u952e\u5f02\u5e38...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(Connection connection, String sql, Object ... params) throws SQLException {
        Long beforeExecute = null;
        Long afterExecute = null;
        int row = 0;
        PreparedStatement ps = null;
        try {
            ps = connection.prepareStatement(sql);
            this.statementReplacement(ps, params);
            if (log.isDebugEnabled()) {
                beforeExecute = DateTimeKit.current(false);
            }
            row = ps.executeUpdate();
            if (log.isDebugEnabled()) {
                afterExecute = DateTimeKit.current(false);
            }
            int n = row;
            if (ps != null) {
                this.close(ps);
            }
            this.sqlLog(sql, beforeExecute, afterExecute, row, params);
            return n;
        }
        catch (Throwable throwable) {
            if (ps != null) {
                this.close(ps);
            }
            this.sqlLog(sql, beforeExecute, afterExecute, row, params);
            throw throwable;
        }
    }

    @Override
    public <T> T executeQueryOne(Connection connection, Class<T> resultClass, String sql, Object ... params) throws SQLException {
        List result = this.executeQuery(connection, new ArrayList(1), resultClass, sql, params);
        int size = result.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return (T)result.get(0);
        }
        throw new ToolBoxException("\u67e5\u8be2\u7ed3\u679c\u4e3a\u591a\u4e2a\u65e0\u6cd5\u5c01\u88c5\u81f3\u5355\u4e2a\u5bf9\u8c61\u3010{}\u3011\u4e2d...", resultClass);
    }

    @Override
    public <T> List<T> executeQueryList(Connection connection, Class<? extends List> resultListClass, Class<T> resultClass, String sql, Object ... params) throws SQLException {
        List<T> result = ClassKit.newInstanceConstructorsDefaultValue(resultListClass);
        result = this.executeQuery(connection, result, resultClass, sql, params);
        return result;
    }

    private <T> List<T> executeQuery(Connection connection, List<T> result, Class<T> resultClass, String sql, Object ... params) throws SQLException {
        Long beforeExecute = null;
        Long afterExecute = null;
        int row = 0;
        PreparedStatement ps = null;
        ResultSet resultSet = null;
        try {
            ps = connection.prepareStatement(sql);
            this.statementReplacement(ps, params);
            if (log.isDebugEnabled()) {
                beforeExecute = DateTimeKit.current(false);
            }
            resultSet = ps.executeQuery();
            if (log.isDebugEnabled()) {
                afterExecute = DateTimeKit.current(false);
            }
            result = QueryResultSetKit.putResultSet(resultSet, result, resultClass);
            row = result.size();
            List<T> list = result;
            if (resultSet != null) {
                this.close(resultSet);
            }
            if (ps != null) {
                this.close(ps);
            }
            this.sqlLog(sql, beforeExecute, afterExecute, row, params);
            return list;
        }
        catch (Exception e) {
            try {
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw new ToolBoxException(e);
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    this.close(resultSet);
                }
                if (ps != null) {
                    this.close(ps);
                }
                this.sqlLog(sql, beforeExecute, afterExecute, row, params);
                throw throwable;
            }
        }
    }

    private void close(ResultSet resultSet) {
        try {
            resultSet.close();
        }
        catch (Exception e) {
            LogKit.error(log, "\u7ed3\u679c\u96c6\u5173\u95ed\u9519\u8bef...", e);
        }
    }

    private void close(PreparedStatement ps) {
        try {
            ps.close();
        }
        catch (Exception e) {
            LogKit.error(log, "\u6570\u636e\u58f0\u660e\u5173\u95ed\u9519\u8bef...", e);
        }
    }

    private void sqlLog(String sql, Long beforeExecute, Long afterExecute, int row, Object ... params) {
        if (!log.isDebugEnabled()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        if (CollectionKit.isNotEmpty(params)) {
            for (Object param : params) {
                boolean boo = param == null;
                Object value = boo ? "" : param;
                String simpleName = boo ? "NULL" : param.getClass().getSimpleName();
                builder.append(", ").append(value).append("(").append(simpleName).append(")");
            }
            builder.delete(0, 2);
        }
        LogKit.debug(log, "Statement ==> : {}", (Object)this.beautifySQL(sql));
        LogKit.debug(log, "Params    ==> : {}", (Object)builder.toString());
        LogKit.debug(log, "Rows      ==> : {}", (Object)row);
        if (afterExecute != null && beforeExecute != null) {
            LogKit.debug(log, "consuming ==> : {}/ms", (Object)(afterExecute - beforeExecute));
        }
    }

    private String beautifySQL(String sql) {
        return sql.replaceAll("[\\s\n ]+", " ");
    }

    private void statementReplacement(PreparedStatement ps, Object ... params) throws SQLException {
        if (params == null) {
            return;
        }
        int len = params.length;
        for (int i = 0; i < len; ++i) {
            ps.setObject(i + 1, params[i]);
        }
    }

    private DefaultSqlStatementExecutor() {
    }

    public static synchronized DefaultSqlStatementExecutor getInstance() {
        return defaultSqlStatementExecutor;
    }
}

