/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.http.builder;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestLogInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(RequestLogInterceptor.class);

    public Response intercept(Interceptor.Chain chain) throws IOException {
        String param;
        Request request = chain.request();
        log.debug("\u8bf7\u6c42\u5730\u5740: {}", (Object)request.url());
        log.debug("\u8bf7\u6c42\u65b9\u5f0f: {}", (Object)request.method());
        log.debug("\u8bf7\u6c42\u5934\u90e8\u4fe1\u606f: {}", (Object)request.headers());
        RequestBody requestBody = request.body();
        if (requestBody == null) {
            param = "";
        } else {
            Buffer buffer = new Buffer();
            requestBody.writeTo((BufferedSink)buffer);
            param = buffer.readUtf8();
            MediaType mediaType = requestBody.contentType();
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)param);
            request = request.newBuilder().method(request.method(), body).build();
        }
        log.debug("\u8bf7\u6c42\u53c2\u6570: {}", (Object)param);
        Response response = chain.proceed(request);
        long sent = response.sentRequestAtMillis();
        long received = response.receivedResponseAtMillis();
        log.debug("\u8bf7\u6c42\u8017\u65f6: {}/ms", (Object)(received - sent));
        return response;
    }
}

