/*
 * Decompiled with CFR 0.152.
 */
package net.lulihu.http.builder;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.lulihu.http.builder.HttpBuilder;
import net.lulihu.http.builder.HttpRequestException;
import net.lulihu.http.builder.RequestInterceptor;
import net.lulihu.http.builder.ResponseInterceptor;
import okhttp3.FormBody;
import okhttp3.Interceptor;
import okhttp3.RequestBody;

public class HttpPostBuilder
extends HttpBuilder {
    private FormBody.Builder builder = new FormBody.Builder();

    HttpPostBuilder(String url) {
        super(url);
    }

    @Override
    public HttpPostBuilder setHeader(Map<String, String> header) {
        super.setHeader(header);
        return this;
    }

    @Override
    public HttpPostBuilder addHeader(String key, String value) {
        super.addHeader(key, value);
        return this;
    }

    @Override
    public HttpPostBuilder setConnectTimeout(long timeout, TimeUnit unit) {
        super.setConnectTimeout(timeout, unit);
        return this;
    }

    @Override
    public HttpPostBuilder setReadTimeout(long timeout, TimeUnit unit) {
        super.setReadTimeout(timeout, unit);
        return this;
    }

    @Override
    public HttpPostBuilder addRequestInterceptor(RequestInterceptor requestInterceptor) {
        super.addRequestInterceptor(requestInterceptor);
        return this;
    }

    @Override
    public HttpPostBuilder addResponseInterceptor(ResponseInterceptor responseInterceptor) {
        super.addResponseInterceptor(responseInterceptor);
        return this;
    }

    @Override
    public HttpPostBuilder addNetInterceptor(Interceptor interceptor) {
        super.addNetInterceptor(interceptor);
        return this;
    }

    public HttpPostBuilder setParam(Map<String, String> postParam) {
        for (Map.Entry<String, String> entry : postParam.entrySet()) {
            this.builder.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public HttpPostBuilder addParam(String key, String value) {
        this.builder.add(key, value);
        return this;
    }

    public HttpPostBuilder send() throws HttpRequestException {
        this.requestBuilder.url(this.url);
        this.requestBuilder.post((RequestBody)this.builder.build());
        super.sendRequest();
        return this;
    }
}

